using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Xanthos.Interfaces;

namespace Xanthos.ShrinkSystem
{
	public class ShrinkPotions : Item, IShrinkTool
	{
		private int m_Charges = 1;

		[CommandProperty( AccessLevel.GameMaster )]
		public int ShrinkCharges
		{
			get { return m_Charges; }
			set
			{
				if ( 0 == m_Charges || 0 == (m_Charges = value ))
					Delete();
				else
					InvalidateProperties();
			}
		}

		[Constructable]
		public ShrinkPotions() : base( 0xE2B )
		{
			Weight = 1.0;
			Movable = true;
			Name = "Shrink Potion";
			// 			LootType = Regular;
			Hue = 2414;
		}

		public ShrinkPotions( Serial serial ) : base( serial )
		{
		}


		public override void OnDoubleClick( Mobile from )
		{
			bool isStaff = from.AccessLevel != AccessLevel.Player;
			if ( !IsChildOf( from.Backpack ) )
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			
			else if ( from.Skills[SkillName.AnimalTaming].Value >= ShrinkConfig.TamingRequired )
				from.Target = new Xanthos.ShrinkSystem.ShrinkTarget( from, this, isStaff );
			else
				from.SendMessage( "You must have at least " + ShrinkConfig.TamingRequired + " animal taming to use a Shrink Potions." );
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
			writer.Write( m_Charges );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			m_Charges = reader.ReadInt();
		}
	}
}
