using System;
using Server;
using Server.Network;

namespace Server.Items
{
	public class SuperPotion : BasePotion
	{

		[Constructable]
		public SuperPotion() : base( 3846, PotionEffect.SuperPotion )
		{
			Hue = 12;
			Name = "a Revitalize potion";
		}

		public SuperPotion( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override void Drink( Mobile m )
		{
			if ( m.Mana < m.ManaMax || m.Hits < m.HitsMax || m.Stam < m.StamMax || m.Poisoned )
			{
				if ( m.BeginAction( typeof( SuperPotion ) ) )
				{

					m.FixedParticles( 0x376A, 9, 32, 5007, EffectLayer.Waist );
					m.PlaySound( 654 );

					m.Poison = null;
					m.Hits = m.HitsMax;
					m.Mana = m.ManaMax;
					m.Stam = m.StamMax;
					m.SendMessage( "You feel completely refreshed!" );

					BasePotion.PlayDrinkEffect( m );

					this.Consume();
					
					Timer.DelayCall( TimeSpan.FromSeconds( 20.0 ), new TimerStateCallback( SuperPotionLock ), m );
				}
				else
					m.LocalOverheadMessage( MessageType.Regular, 0x22, true, "You must wait a few seconds before using another Revitalize potion." );

			}
			else
				m.SendMessage( "You decide against drinking this potion, as you are completely healthy." );
		}

		private static void SuperPotionLock( object state )
		{
			( ( Mobile ) state ).EndAction( typeof( SuperPotion ) );
		}
	}
}
