using System;

namespace Server.Items
{
	public class PoukazkaNaDF : Item
	{
		[Constructable]
		public PoukazkaNaDF() : this( 1 )
		{
		}

		[Constructable]
		public PoukazkaNaDF( int amount ) : base( 5360 )
		{
			Weight = 0.0;
			Stackable = false;
			Amount = amount;
			Name = "Poukazka Na DF";
			Hue = 1060;
         LootType = LootType.Blessed;
		}

		public PoukazkaNaDF( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}