using System;

namespace Server.Items
{
	public class PSToken : Item
	{
		[Constructable]
		public PSToken() : this( 1 )
		{
		}

		[Constructable]
		public PSToken( int amount ) : base( 0x1422 )
		{
			Weight = 1.0;
			Stackable = true;
			Amount = amount;
			Name = "Power Scroll Token";
			Hue = 0x481;
		}

		public PSToken( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}