/*  _________________________________
 -=(_)_______________________________)=-
   /   .   .   . ____  . ___      _/
  /~ /    /   / /     / /   )2005 /
 (~ (____(___/ (____ / /___/     (
  \ ----------------------------- \
   \     lucidnagual@gmail.com     \
    \_     ===================      \
     \   -Admin of "The Conjuring"-  \
      \_     ===================     ~\
       )       Ultimate Quiver         )
      /~      Version [1].0.0        _/
    _/_______________________________/
 -=(_)_______________________________)=-
 */
using System;

namespace Server.Items
{
	[Flipable( 0x2FB7, 0x3171 )]
	public class ElvenQuiver : BaseQuiver
	{
		public override int LabelNumber{ get{ return 1032215; } } // elven quiver
      public override int MaxWeight{ get{ return 350; } }
		
		[Constructable]
		public ElvenQuiver() : base( 0x2FB7 )
		{
			LowerAmmoCost = 35;
			ReduxPercent = 50;
			MaxAmmo = 5000;
		}

		public ElvenQuiver( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			if ( Layer != Layer.MiddleTorso )
				Layer = Layer.MiddleTorso;
		}
	}
}

