using System;
using Server.Misc;
using Server.Items;
using Server.Commands;
using Server.Gumps;
using Server.Mobiles;

namespace Server.Commands
{
   public class QuiverCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "toulec", AccessLevel.Player, new CommandEventHandler( Quiver_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "toulec" )] 
     [Description( "otevre gump toulce pokud je nasazen")] 
     public static void Quiver_OnCommand( CommandEventArgs e )
     {
         BaseQuiver quiver = e.Mobile.FindItemOnLayer( Layer.MiddleTorso ) as BaseQuiver;
         
         if ( quiver != null )
         {
			   if( e.Mobile.HasGump( typeof(BaseQuiver.QuiverGump) ) )
				  e.Mobile.CloseGump( typeof(BaseQuiver.QuiverGump) );

			   e.Mobile.SendGump( new BaseQuiver.QuiverGump( quiver ) );
         }
         else
            e.Mobile.SendMessage( "Nemas na zadech zadny toulec!" );
     }
   }
}