using System;

namespace Server.Items
{
	[Flipable( 0x2FB7, 0x3171 )]
	public class RangersQuiver : BaseQuiver
	{
      public override int MaxWeight{ get{ return 350; } }
		
		[Constructable]
		public RangersQuiver() : base( 0x2FB7 )
		{
			Name = "Ranger's Quiver";
         Hue = Utility.RandomBirdHue();
         LowerAmmoCost = Utility.RandomList( 15,20,25,30 );
			ReduxPercent = Utility.RandomList( 25,30,35,40,45,50 );
			Attributes.WeaponDamage = Utility.RandomList( 5,10,15 );
			
			if ( Utility.RandomBool() )
			   Attributes.WeaponDamage = Utility.RandomList( 5,10,15 );
			else
			   Attributes.WeaponSpeed = Utility.RandomList( 5,10,15 );
			   
			if ( Utility.RandomBool() )
			{
            if ( Utility.RandomBool() )
               Attributes.AttackChance = Utility.RandomList( 5,10,15 );
//                SkillBonuses.SetValues( 0, SkillName.Archery, Utility.RandomList( 1,3,5 ) );
            else
               Attributes.DefendChance = Utility.RandomList( 5,10,15 );
//                SkillBonuses.SetValues( 0, SkillName.Tactics, Utility.RandomList( 1,3,5 ) );
         }
         
			if ( Utility.RandomBool() )
			{
            if ( Utility.RandomBool() )
               Attributes.BonusDex = Utility.RandomMinMax( 2, 6 );
            else
               Attributes.BonusStr = Utility.RandomMinMax( 2, 6 );
         }
		}

		public RangersQuiver( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			if ( Layer != Layer.MiddleTorso )
				Layer = Layer.MiddleTorso;
		}
	}
}

