/*  _________________________________
 -=(_)_______________________________)=-
   /   .   .   . ____  . ___      _/
  /~ /    /   / /     / /   )2005 /
 (~ (____(___/ (____ / /___/     (
  \ ----------------------------- \
   \     lucidnagual@gmail.com     \
    \_     ===================      \
     \   -Admin of "The Conjuring"-  \
      \_     ===================     ~\
       )       Ultimate Quiver         )
      /~      Version [1].0.0        _/
    _/_______________________________/
 -=(_)_______________________________)=-
 */
using System;


namespace Server.Items
{
	[Flipable( 0x2B02, 0x2B03 )]
	public class UltimateQuiver : BaseQuiver
	{
		public override int MaxWeight{ get{ return 600; } }

		[Constructable]
		public UltimateQuiver() : base( 0x2B03 )
		{
			Name = "Ultimate Quiver";
			LootType=LootType.Cursed;
			Attributes.WeaponSpeed = 10;
			Attributes.WeaponDamage = 10;
			Attributes.BonusDex = 10;
			LowerAmmoCost = 80; //Lower Ammo Cost Mod
			ReduxPercent = 75;
			SkillBonuses.SetValues( 0, SkillName.Archery, 5.0 );
		}

		public override bool OnEquip( Mobile from )
		{
			Name = from.Name + "'s Quiver";

			return base.OnEquip(from);
		}

		public override void OnRemoved( object parent )
		{
			base.OnRemoved(parent);

			Name = "Ultimate Quiver";

			return;
		}


		public UltimateQuiver( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			if ( Layer != Layer.MiddleTorso )
				Layer = Layer.MiddleTorso;
		}
	}
}

