using System;
using Server.Mobiles;

namespace Server.Items
{
	public class RegenItem : BaseArmor
	{
		public override ArmorMaterialType MaterialType{ get{ return ArmorMaterialType.Leather; } }
		public override CraftResource DefaultResource{ get{ return CraftResource.RegularLeather; } }
		public override ArmorMeditationAllowance DefMedAllowance{ get{ return ArmorMeditationAllowance.All; } }
      
		private int m_Lifespan;
		private int m_Interval;
		private bool m_Running;
		private int m_RegenHits;
		private int m_RegenMana;
		private int m_RegenStam;
      
		[CommandProperty( AccessLevel.GameMaster )]
		public int Lifespan
		{
			get{ return m_Lifespan; }
			set{ m_Lifespan = value; InvalidateProperties(); }
		}
      
		[CommandProperty( AccessLevel.GameMaster )]
		public int Interval
		{
			get{ return m_Interval; }
			set{ m_Interval = value; InvalidateProperties(); if ( m_Interval < 1 ) m_Interval = 1; }
		}
      
		[CommandProperty( AccessLevel.GameMaster )]
		public bool Running
		{
			get{ return m_Running; }
			set{ m_Running = value; InvalidateProperties(); }
		}
      
		[CommandProperty( AccessLevel.GameMaster )]
		public int RegenHits
		{
			get{ return m_RegenHits; }
			set{ m_RegenHits = value; InvalidateProperties(); if ( m_RegenHits < 1 ) m_RegenHits = 1; }
		}
      
		[CommandProperty( AccessLevel.GameMaster )]
		public int RegenMana
		{
			get{ return m_RegenMana; }
			set{ m_RegenMana = value; InvalidateProperties(); if ( m_RegenMana < 1 ) m_RegenMana = 1; }
		}
      
		[CommandProperty( AccessLevel.GameMaster )]
		public int RegenStam
		{
			get{ return m_RegenStam; }
			set{ m_RegenStam = value; InvalidateProperties(); if ( m_RegenStam < 1 ) m_RegenStam = 1; }
		}

		[Constructable]
		public RegenItem() : base( RandomTalisman.GetRandomID() )
		{
			Name = "talisman of regeneration";
			Weight = 1.0;
			Layer = Layer.Talisman;
         RegenStam = RegenMana = RegenHits = 10;
         Lifespan = 3600;
         Running = false;
         Interval = 10;
		}
      
		public override void GetProperties( ObjectPropertyList list )
		{
         base.GetProperties( list );
			
			list.Add( 1042971, String.Format( "{0} hp {1} mana {2} stam kazdych {3} sec", m_RegenHits, m_RegenMana, m_RegenStam, m_Interval ) );
         
         if ( m_Lifespan > 0 )
				list.Add( 1072517, m_Lifespan.ToString() ); // Lifespan: ~1_val~ seconds
            
			if ( m_Running )
				list.Add( 1075352 ); // Running
		}
      
		public override void OnDoubleClick( Mobile from )
		{
			if ( m_Lifespan < 1 )
         {
            Decay();
            return;
         }         
         
         if ( ( Layer == Layer.Invalid && IsChildOf( from.Backpack ) ) || Parent == from )
			{
            if ( !m_Running )
            {
               Running = true;
               from.SendMessage( "Zapnuto" );
               StartTimer();
            }
            else
            {
               Running = false;
               from.SendMessage( "Vypnuto" );
			      StopTimer();
            }
         }
			else
         {
            if ( Layer == Layer.Invalid )
				  from.SendMessage( "Predmet musis mit v batohu" );
            else
				  from.SendMessage( "Predmet musis mit nasazen" );
         }
		}

		public RegenItem( Serial serial ) : base( serial )
		{
		}

		public override void OnAfterDelete()
		{
			StopTimer();
			base.OnAfterDelete();
		}
		
		private Timer m_Timer;		
		
		public virtual void StartTimer()
		{
			if ( m_Timer != null )
				return;
				
// 			m_Lifespan = Lifespan;
			m_Timer = Timer.DelayCall( TimeSpan.FromSeconds( m_Interval ), TimeSpan.FromSeconds( m_Interval ), new TimerCallback( Slice ) );
			m_Timer.Priority = TimerPriority.FiftyMS;
		}
		
		public virtual void StopTimer()
		{
			if ( m_Timer != null )
				m_Timer.Stop();

			m_Timer = null;
		}
		
		public virtual void Slice()
		{
			if ( !m_Running )
         {
            StopTimer();
            return;
         }
         
         m_Lifespan -= m_Interval;
			
			InvalidateProperties();
			
			if ( m_Lifespan <= 0 )
				Decay();
         else
         {
    			if ( RootParent is PlayerMobile )
            {
               Mobile m = (Mobile) RootParent;
               
              if ( ( Layer == Layer.Invalid && IsChildOf( m.Backpack ) ) || m == Parent )
      			{
                 m.Hits += m_RegenHits;
                 m.Mana += m_RegenMana;
                 m.Stam += m_RegenStam;               
                 
      				IEntity from = new Entity( Serial.Zero, new Point3D( m.X, m.Y, m.Z - 25 ), m.Map );
      				IEntity to = new Entity( Serial.Zero, new Point3D( m.X, m.Y, m.Z + 10 ), m.Map );
      				Effects.SendMovingParticles( from, to, 0x376A, 1, 0, false, false, 93, 2, 9501, 1, 0, EffectLayer.Waist, 0x100 );    				
      				Effects.PlaySound( m.Location, m.Map, 0x1E3 );
      			}
              else
              {
                 StopTimer();
                 Running = false;
                 return;
              }
            }
            else
            {
               StopTimer();
               Running = false;
               return;
            }
         }
		}
		
		public virtual void Decay()
		{
			if ( RootParent is Mobile )
			{
				Mobile parent = (Mobile) RootParent;
				
				if ( Name == null )
					parent.SendLocalizedMessage( 1072515, "#" + LabelNumber ); // The ~1_name~ expired...
				else
					parent.SendLocalizedMessage( 1072515, Name ); // The ~1_name~ expired...
					
				Effects.SendLocationParticles( EffectItem.Create( parent.Location, parent.Map, EffectItem.DefaultDuration ), 0x3728, 8, 20, 5042 );
				Effects.PlaySound( parent.Location, parent.Map, 0x201 );
			}
			else
			{
				Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 0x3728, 8, 20, 5042 );
				Effects.PlaySound( Location, Map, 0x201 );
			}			
			
			StopTimer();
			Delete();
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
			
			writer.Write( (int) m_Lifespan );
			writer.Write( (int) m_Interval );
			writer.Write( (bool) m_Running );
			writer.Write( (int) m_RegenHits );
			writer.Write( (int) m_RegenMana );
			writer.Write( (int) m_RegenStam );
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			m_Lifespan = reader.ReadInt();
			m_Interval = reader.ReadInt();
			m_Running = reader.ReadBool();
			m_RegenHits = reader.ReadInt();
			m_RegenMana = reader.ReadInt();
			m_RegenStam = reader.ReadInt();
         
			if ( m_Running )
            StartTimer();
		}
	}
}

