using System;
using System.Collections;
using Server.Network;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class RottenTomato : SelfDeletingItem
	{
		[Constructable]
		public RottenTomato() : base(2512, "Shnile rajce", 900)
		{
			Hue = 327;
			Movable = true;
			Stackable = false;
		}

		public RottenTomato( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( version == 0 )
			{
				Weight = 1.0;
			}
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) )
			{
				from.SendLocalizedMessage( 1042010 ); // You must have the object in your backpack to use it.
			}
			else if ( from.CanBeginAction( typeof( RottenTomato ) ) )
			{
				from.SendMessage( "Mir dobre!" );
				from.Target = new TomatoTarget( from, this );
			}
			else
			{
				from.SendMessage( "Jeste nemuzes hodit znovu" );
			}
		}

		private class InternalTimer : Timer
		{
			private Mobile m_From;

			public InternalTimer( Mobile from ) : base( TimeSpan.FromSeconds( 5.0 ) )
			{
				m_From = from;
			}

			protected override void OnTick()
			{
				m_From.EndAction( typeof( RottenTomato ) );
			}
		}

		private class TomatoTarget : Target
		{
			private Mobile m_Thrower;
			private Item m_Tomato;

			public TomatoTarget( Mobile thrower, Item tomato ) : base ( 10, false, TargetFlags.None )
			{
				m_Thrower = thrower;
				m_Tomato = tomato;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( target == from )
				{
					from.SendLocalizedMessage( 1005576 ); // You can't throw this at yourself.
				}
				else if ( target is Mobile )
				{
					Mobile targ = (Mobile) target;

					if ( from.AccessLevel >= targ.AccessLevel )
					{
						if ( from.BeginAction( typeof( RottenTomato ) ) )
						{
							new InternalTimer( from ).Start();

							from.PlaySound( 0x145 );

							from.Animate( 9, 1, 1, true, false, 0 );

							from.SendMessage( "Hodil{0} jsi shnile rajce na {1}", from.Female?"a":"", targ.Name );

							Effects.SendMovingEffect( from, targ, 2512, 7, 0, false, true, 327, 0 );
						}
						else
						{
							from.SendMessage( "Jeste nemuzes hodit znovu" );
						}
					}
					else
					{
						from.SendMessage( "Na tento cil nemuzes rajce hodit" );
					}
				}
				else
				{
					from.SendMessage( "Na tento cil nemuzes rajce hodit" );
				}
			}
		}
	}
}