using System;
using Server.Network;
using Server.Items;
using Server.Gumps;
using System.Collections;
using Server.ContextMenus;
using System.Collections.Generic;
using Server.Targeting;
using Server.Mobiles;

namespace Server.Items
{
    public class SkillBall : Item
    {
        private double m_SkillBonus = 5.0;
        private string m_BaseName = "a skill ball +";

        [CommandProperty(AccessLevel.GameMaster)]
        public double SkillBonus
        {
            get { return m_SkillBonus; }
            set
            {
                m_SkillBonus = value;
                this.Name = m_BaseName + m_SkillBonus.ToString("F1");
                this.InvalidateProperties();
            }
        }

        [Constructable]
        public SkillBall(double SkillBonus)
            : base(6249)
        {
            m_SkillBonus = SkillBonus;
            Movable = true;
            Name = m_BaseName + Convert.ToString(SkillBonus);
            Hue = 1198;
        }

        [Constructable]
        public SkillBall()
            : base(6249)
        {
            Name = m_BaseName + Convert.ToString(SkillBonus);
            Movable = true;
            Hue = 1198;
        }

        public SkillBall(Serial serial)
            : base(serial)
        {
        }

        public override void OnDoubleClick(Mobile from)
        {
            from.CloseGump(typeof(SkillBallGump));
            if ((this.SkillBonus == 0) && (from.AccessLevel < AccessLevel.GameMaster))
            {
                from.SendMessage("This Skill Ball isn't charged. Please page for a GM.");
                return;
            }
            else if ((from.AccessLevel >= AccessLevel.GameMaster) && (this.SkillBonus == 0))
            {
                from.SendGump(new PropertiesGump(from, this));
                return;
            }

            if (!IsChildOf(from.Backpack))
                from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
            else if ( from is PlayerMobile && ((PlayerMobile)from).Young )
                from.SendMessage("Predmet nelze pouzit se statusem Young");
            else
                from.SendGump(new SkillBallGump(from, this));
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
            writer.Write((double)m_SkillBonus);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {

                case 0:
                    {
                        m_SkillBonus = reader.ReadDouble();
                        break;
                    }
            }
        }

        public override void GetContextMenuEntries(Mobile from, List<ContextMenuEntry> list)
        {
            base.GetContextMenuEntries(from, list);

            if ( this.ItemID != 5360 )
               list.Add(new CombineSkillBallsEntry(from, this));
        }

        public class CombineSkillBallsEntry : ContextMenuEntry
        {
            private Mobile m_From;
            private SkillBall m_skb;

            public CombineSkillBallsEntry(Mobile from, SkillBall skb)
                : base(0169, 1)//Connection	3000169
            {
                m_From = from;
                m_skb = skb;
            }

            public override void OnClick()
            {
                m_From.CloseGump(typeof(SkillBallGump));
                
                if (!m_skb.IsChildOf(m_From.Backpack))
                    m_From.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
                else
                    m_From.Target = new TargetInternal(m_skb);
            }
        }

        private class TargetInternal : Target
        {
            private SkillBall m_skb;

            public TargetInternal(SkillBall skb)
                : base(-1, true, TargetFlags.None)
            {
                m_skb = skb;

                CheckLOS = false;
            }

            protected override void OnTarget(Mobile from, object targeted)
            {
                if (m_skb.Deleted)
                    return;

                if (m_skb.IsChildOf(from.Backpack))
                {
                    if (targeted is SkillBall && targeted != m_skb)
                    {
                        SkillBall tg_skb = targeted as SkillBall;

                        if (!tg_skb.IsChildOf(from.Backpack))
                            from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
                        else if ( ( m_skb.BlessedFor != null || tg_skb.BlessedFor != null ) && !( m_skb.BlessedFor == from && tg_skb.BlessedFor == from ) )
                           from.SendMessage("Muzes spojit jen dva svoje skillbally");
                        else if (tg_skb.SkillBonus > 0)
                        {
                            m_skb.SkillBonus += tg_skb.SkillBonus;
                            tg_skb.Delete();
                            from.SendMessage("Skillbally byly skombinovany");
                        }
                    }
                    else
                        from.SendMessage("Musis zamerit druhy skillball");
                }
                else
                {
                    from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
                }
            }
        }
    }
}

namespace Server.Gumps
{
    public class SkillBallGump : Gump
    {
        private const int FieldsPerPage = 14;

        private Skill m_Skill;
        private SkillBall m_skb;

        public SkillBallGump(Mobile from, SkillBall skb)
            : base(20, 30)
        {
            m_skb = skb;

            AddPage(0);
            AddBackground(0, 0, 260, 351, 5054);

            AddImageTiled(10, 10, 240, 23, 0x52);
            AddImageTiled(11, 11, 238, 21, 0xBBC);

            AddLabel(65, 11, 0, "Skilly ktere lze zvysit");

            AddPage(1);

            int page = 1;
            int index = 0;

            Skills skills = from.Skills;

            int number;
            if (Core.AOS)
                number = 0;
            else
                number = 3;

            for (int i = 0; i < (skills.Length - number); ++i)
            {
                if (index >= FieldsPerPage)
                {
                    AddButton(231, 13, 0x15E1, 0x15E5, 0, GumpButtonType.Page, page + 1);

                    ++page;
                    index = 0;

                    AddPage(page);

                    AddButton(213, 13, 0x15E3, 0x15E7, 0, GumpButtonType.Page, page - 1);
                }

                Skill skill = skills[i];

                if (skill.Base < skill.Cap)
                {

                    AddImageTiled(10, 32 + (index * 22), 240, 23, 0x52);
                    AddImageTiled(11, 33 + (index * 22), 238, 21, 0xBBC);

                    AddLabelCropped(13, 33 + (index * 22), 150, 21, 0, skill.Name);
                    AddImageTiled(180, 34 + (index * 22), 50, 19, 0x52);
                    AddImageTiled(181, 35 + (index * 22), 48, 17, 0xBBC);
                    AddLabelCropped(182, 35 + (index * 22), 40, 21, 0, skill.Base.ToString("F1"));

                    if (from.AccessLevel >= AccessLevel.Player)
                        AddButton(231, 35 + (index * 22), 0x15E1, 0x15E5, i + 1, GumpButtonType.Reply, 0);
                    else
                        AddImage(231, 35 + (index * 22), 0x2622);

                    ++index;
                }
            }
        }

        public override void OnResponse(NetState state, RelayInfo info)
        {
            Mobile from = state.Mobile;

            if (from == null)
                return;

            if (!m_skb.IsChildOf(from.Backpack))
            {
               from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
               from.CloseGump(typeof(SkillBallGump));
               return;
            }

            if (info.ButtonID > 0)
            {
                m_Skill = from.Skills[(info.ButtonID - 1)];

                if (m_Skill == null)
                    return;

                double count = 0;
                for (int i = 0; i < from.Skills.Length; ++i)
                    count += from.Skills[i].Base;

                if ((count + m_skb.SkillBonus) > (from.SkillsCap / 10))
                {
                    from.SendMessage("Nemuzes prekrocit skills cap.");
                    return;
                }

                if (m_Skill.Base + m_skb.SkillBonus < m_Skill.Cap)
                {
                    m_Skill.Base += m_skb.SkillBonus;
                    m_skb.SkillBonus -= m_skb.SkillBonus;
                    from.CloseGump(typeof(SkillBallGump));
                    if (m_skb.SkillBonus < 0.1)
                    {
                        m_skb.Delete();
                    }
                }
                else if (m_Skill.Base < m_Skill.Cap)
                {
                    double rozdil = m_Skill.Cap - m_Skill.Base;

                    if (rozdil > m_skb.SkillBonus)
                    {
                        rozdil = m_skb.SkillBonus;
                    }
                    
                    m_skb.SkillBonus -= rozdil;
                    m_skb.SkillBonus = Math.Round((double)m_skb.SkillBonus,1);
                    m_Skill.Base += rozdil;
                    from.CloseGump(typeof(SkillBallGump));
                    if (m_skb.SkillBonus < 0.1)
                    {
                        m_skb.Delete();
                    }
                }
                else
                    from.SendMessage("You have to choose another skill.");
            }
        }
    }
}
