using System;
using Server.Network;
using Server.Items;
using Server.Gumps;
using System.Collections;
using Server.ContextMenus;
using System.Collections.Generic;

namespace Server.Items
{
    public class StatScroll : Item
    {
        private int m_StatBonus = 30;
        private string m_BaseName = "a stat scroll +";

        [CommandProperty(AccessLevel.GameMaster)]
        public int StatBonus
        {
            get { return m_StatBonus; }
            set
            {
                m_StatBonus = value;
                this.Name = m_BaseName + m_StatBonus.ToString("F1");
                this.InvalidateProperties();
            }
        }

        [Constructable]
        public StatScroll(int StatBonus)
            : base(5360)
        {
            m_StatBonus = StatBonus;
            Movable = true;
            Name = m_BaseName + Convert.ToString(StatBonus);
            Hue = 1270;
            LootType = LootType.Blessed;
        }

        [Constructable]
        public StatScroll()
            : base(5360)
        {
            Name = m_BaseName + Convert.ToString(StatBonus);
            Movable = true;
            LootType = LootType.Blessed;
            Hue = 1270;
        }

        public StatScroll(Serial serial)
            : base(serial)
        {
        }

        public override void OnDoubleClick(Mobile from)
        {
            from.CloseGump(typeof(StatScrollGump));
            if ((this.StatBonus == 0) && (from.AccessLevel < AccessLevel.GameMaster))
            {
                from.SendMessage("This stat scroll isn't charged. Please page for a GM.");
                return;
            }
            else if ((from.AccessLevel >= AccessLevel.GameMaster) && (this.StatBonus == 0))
            {
                from.SendGump(new PropertiesGump(from, this));
                return;
            }

            if (!IsChildOf(from.Backpack))
                from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
            else
                from.SendGump(new StatScrollGump(from, this));
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
            writer.Write((int)m_StatBonus);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {

                case 0:
                    {
                        m_StatBonus = reader.ReadInt();
                        break;
                    }
            }
        }
    }
}

namespace Server.Gumps
{
    public class StatScrollGump : Gump
    {
        private StatScroll m_skb;

        public StatScrollGump(Mobile from, StatScroll skb)
            : base(20, 30)
        {
            m_skb = skb;

            AddPage(0);
            AddBackground(0, 0, 260, 110, 5054);
            AddImageTiled(10, 10, 240, 23, 0x52);
            AddImageTiled(11, 11, 238, 21, 0xBBC);
            AddLabel(65, 11, 0, "+" + m_skb.StatBonus.ToString("F1") + " do vybraneho statu" );
            
            string[] StatName = new string[] { "Strength", "Dexterity", "Inteligence" };
            int[] StatValue = new int[] { from.RawStr, from.RawDex, from.RawInt };
            
            for (int i = 0; i < 3; ++i)
            {
                AddImageTiled(10, 32 + (i * 22), 240, 23, 0x52);
                AddImageTiled(11, 33 + (i * 22), 238, 21, 0xBBC);
    
                AddLabelCropped(13, 33 + (i * 22), 150, 21, 0, StatName[i]);
                AddImageTiled(180, 34 + (i * 22), 50, 19, 0x52);
                AddImageTiled(181, 35 + (i * 22), 48, 17, 0xBBC);
                AddLabelCropped(182, 35 + (i * 22), 234, 21, 0, StatValue[i].ToString("F1"));
    
                AddButton(231, 35 + (i * 22), 0x15E1, 0x15E5, i + 1, GumpButtonType.Reply, 0);
            }
        }

        public override void OnResponse(NetState state, RelayInfo info)
        {
            Mobile from = state.Mobile;

            if (from == null)
                return;

            if (!m_skb.IsChildOf(from.Backpack))
            {
               from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
               from.CloseGump(typeof(StatScrollGump));
               return;
            }

            if (info.ButtonID > 0)
            {
                if ((m_skb.StatBonus + from.RawStatTotal) > from.StatCap )
                {
                    from.SendMessage("Nemuzes prekrocit stat cap." );
                    return;
                }

                if (info.ButtonID == 1 )
                {
                    if ( ( from.RawStr + m_skb.StatBonus ) <= 130 )
                    {
                      from.RawStr += m_skb.StatBonus;
                      from.CloseGump(typeof(StatScrollGump));
                      m_skb.Delete();
                      from.SendMessage("Stat Strength byl navysen");
                    }
                    else
                     from.SendMessage("Nelze prekrocit hranici 130 Strength");
                }                    
                else if (info.ButtonID == 2 )
                {
                    if ( ( from.RawDex + m_skb.StatBonus ) <= 130 )
                    {
                       from.RawDex += m_skb.StatBonus;
                       from.CloseGump(typeof(StatScrollGump));
                       m_skb.Delete();
                       from.SendMessage("Stat Dexterity byl navysen");
                    }
                    else
                        from.SendMessage("Nelze prekrocit hranici 130 Dexterity");
                }
                else if (info.ButtonID == 3 )
                {
                    if ( ( from.RawInt + m_skb.StatBonus ) <= 130 )
                    {
                      from.RawInt += m_skb.StatBonus;
                      from.CloseGump(typeof(StatScrollGump));
                      m_skb.Delete();
                      from.SendMessage("Stat Inteligence byl navysen");
                    }
                    else
                        from.SendMessage("Nelze prekrocit hranici 130 Inteligence");
                }
            }
        }
    }
}
