using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
    public class CavemansIdol : BaseTalisman
    {
        public override bool ForceShowName { get { return true; } }

        [Constructable]
        public CavemansIdol() : base(12121)
        {
            Hue = 1947;
            Name = "caveman's idol";
            LootType = LootType.Cursed;
            Protection = RandomTalisman.GetRandomProtection();
            Killer = new TalismanAttribute(typeof(Jelly), Utility.RandomMinMax(20, 50), "Jelly");
            Slayer = TalismanSlayerName.Vermin;
            MaxChargeTime = 1800;
            MaxCharges = Utility.RandomMinMax(40, 50);
            Charges = MaxCharges;
            Summoner = new TalismanAttribute(typeof(Ribs), 2, 1022546);

            SkillBonuses.SetValues(1, SkillName.Macing, 5.0);
            SkillBonuses.SetValues(2, SkillName.Anatomy, 5.0);
            SkillBonuses.SetValues(3, SkillName.Healing, 5.0);
            Attributes.Luck = 70;
            Attributes.BonusStam = 10;
            Attributes.ReflectPhysical = 25;
        }

        public CavemansIdol(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }
}
