using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
	public class ChaoticAmulet : BaseTalisman
	{
		public override bool ForceShowName{ get{ return true; } }

		private SkillMod m_SkillMod;

		[Constructable]
		public ChaoticAmulet() : base( 0x2F5B )
		{
			Name= "Chaotic Amulet";
			Hue = 1156;
			LootType=LootType.Cursed;
			// 			Blessed = RandomTalisman.GetRandomBlessed();
			Protection = new TalismanAttribute( typeof( BlackLich ), Utility.RandomMinMax( 20, 40 ), "Black Lich" );;
			Killer = new TalismanAttribute( typeof( BoneWarriorKnight ), Utility.RandomMinMax( 20, 50 ), "Bone Warrior Knight" );
			Slayer = TalismanSlayerName.Mage;
			MaxChargeTime = 1800;
			MaxCharges = Utility.RandomMinMax( 40, 60 );
			Charges = MaxCharges;
			Summoner = new TalismanAttribute( typeof( EnhancedBandage ), 20, 1023817 );

			Attributes.Luck = 200;
			Attributes.AttackChance = 5;
			Attributes.DefendChance = 5;
			Attributes.ReflectPhysical = 10;
			SkillBonuses.SetValues( 1, SkillName.Tactics, 5.0 );
			SkillBonuses.SetValues( 2, SkillName.Swords, 5.0 );
		}
		
		public override void OnAdded( object parent )
		{
			base.OnAdded( parent );

			if ( parent is Mobile )
			{
				if ( m_SkillMod != null )
					m_SkillMod.Remove();

				m_SkillMod = new DefaultSkillMod( SkillName.Chivalry, true, 10 );
				m_SkillMod.ObeyCap = false;
				((Mobile)parent).AddSkillMod( m_SkillMod );
			}
		}

		public override void OnRemoved( object parent )
		{
			base.OnRemoved( parent );

			if ( m_SkillMod != null )
				m_SkillMod.Remove();

			m_SkillMod = null;
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			
			list.Add( 1060451, "{0}\t{1}", SkillName.Chivalry, "10" ); // ~1_skillname~ +~2_val~
		}
		
		public ChaoticAmulet( Serial serial ) :  base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			if ( Parent is Mobile )
			{
				if ( m_SkillMod != null )
					m_SkillMod.Remove();

				m_SkillMod = new DefaultSkillMod( SkillName.Chivalry, true, 10 );
				m_SkillMod.ObeyCap = false;
				((Mobile)Parent).AddSkillMod( m_SkillMod );
			}
		}
	}
}
