using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
	public class MarkOfWerewolf : BaseTalisman
	{
		public override bool ForceShowName{ get{ return true; } }
		
		[Constructable]
		public MarkOfWerewolf() : base( 12120 )
		{
			Hue = 1190;
			Name = "A Mark of the Werewolf";
			LootType=LootType.Cursed;
			// 			Blessed = RandomTalisman.GetRandomBlessed();
			Protection = new TalismanAttribute( typeof( Vampire ), Utility.RandomMinMax( 15, 40 ), "Vampire" );;
			MaxChargeTime = 1800;
			MaxCharges = Utility.RandomMinMax( 30, 50 );
			Charges = MaxCharges;
			Summoner = new TalismanAttribute( typeof( SummonedBakeKitsune ), 0, 1030083 );
			
			Attributes.RegenHits = 2;
			Attributes.RegenMana = 2;
			Attributes.RegenStam = 2;
			Attributes.NightSight = 1;
			Attributes.EnhancePotions = 25;
			Slayer = TalismanSlayerName.Bat;
		}
		
		public MarkOfWerewolf( Serial serial ) :  base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
