using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
	public class MerlinsAmulet : BaseTalisman
	{
      private DateTime m_NextSpecial;
		public DateTime NextSpecial { get { return m_NextSpecial; } set { m_NextSpecial = value; } }
      
      public override bool ForceShowName{ get{ return true; } }
		
		[Constructable]
		public MerlinsAmulet() : base( 12121 )
		{
			Hue = 195;
			Name = "merlin's amulet";
         Blessed = RandomTalisman.GetRandomBlessed();
			Protection = new TalismanAttribute( typeof( Mordrid ), 30, "Mordrid" );
         Slayer = TalismanSlayerName.Flame;
			Skill = SkillName.Inscribe;
			SuccessBonus = Utility.RandomMinMax( 15, 30 );
			ExceptionalBonus = Utility.RandomMinMax( 15, 30 );
			MaxChargeTime = 1800;
			MaxCharges = Utility.RandomMinMax( 30, 50 );
			Charges = MaxCharges;
			Summoner = new TalismanAttribute( typeof( BlankScroll ), 30, 1044377 );
			
			Attributes.BonusMana = 20;
			Attributes.SpellDamage = 25;
			Attributes.Luck = 100;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>Casting while moving\nCritical Spells create paralyzing shield<basefont color=White>" );
		}
		
		public MerlinsAmulet( Serial serial ) :  base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
