using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
	public class SignOfAncientVampire : BaseTalisman
	{
		public override bool ForceShowName{ get{ return true; } }
		
		[Constructable]
		public SignOfAncientVampire() : base( 12120 )
		{
			Hue = 1157;
			Name = "A Sign Of The Ancient Vampire";
			LootType=LootType.Cursed;
			// 			Blessed = RandomTalisman.GetRandomBlessed();
			Protection = new TalismanAttribute( typeof( Werewolf ), Utility.RandomMinMax( 15, 40 ), "Werewolf" );;
			MaxChargeTime = 1800;
			MaxCharges = Utility.RandomMinMax( 30, 50 );
			Charges = MaxCharges;
			Summoner = new TalismanAttribute( typeof( SummonedWailingBanshee ), 0, 1072399 );
			
			Attributes.RegenHits = 2;
			Attributes.RegenMana = 2;
			Attributes.RegenStam = 2;
			Attributes.NightSight = 1;
			Attributes.EnhancePotions = 25;
			Slayer = TalismanSlayerName.Wolf;
		}
		
		public SignOfAncientVampire( Serial serial ) :  base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
