using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
	public class TalismanOfWarrior : BaseTalisman
	{
		public override bool ForceShowName{ get{ return true; } }

		[Constructable]
		public TalismanOfWarrior() : base( 0x2F5B )
		{
			Name= "talisman of legendary warrior";
			Hue = 1072;
			Blessed = true;
			Protection = new TalismanAttribute( typeof( DarkPaladin ), 50, "Dark Paladin" );;
			Killer = new TalismanAttribute( typeof( Murderer ), 50, "Murderer" );
			Slayer = TalismanSlayerName.Mage;
			MaxChargeTime = 1800;
			MaxCharges = 100;
			Charges = MaxCharges;
			Summoner = new TalismanAttribute( typeof( EnhancedBandage ), 30, 1023817 );
			Skill = SkillName.Blacksmith;
			SuccessBonus = 35;
			ExceptionalBonus = 35;

			Attributes.Luck = 220;
			Attributes.EnhancePotions = 25;
			Attributes.DefendChance = 10;
			Attributes.ReflectPhysical = 10;
			Attributes.WeaponDamage = 30;
			Attributes.BonusStr = 10;
			Attributes.BonusHits = 10;
			SkillBonuses.SetValues( 0, SkillName.Swords, 10.0 );
			SkillBonuses.SetValues( 1, SkillName.Fencing, 10.0 );
			SkillBonuses.SetValues( 2, SkillName.Macing, 10.0 );
			SkillBonuses.SetValues( 3, SkillName.Tactics, 10.0 );
			SkillBonuses.SetValues( 4, SkillName.Parry, 10.0 );
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=Yellow>Immunity to Mortal strike<basefont color=White>" );
		}
		
		public TalismanOfWarrior( Serial serial ) :  base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
