using System;
using Server;
using Server.Mobiles;
using Server.Network;
using Server.Spells;

namespace Server.Items
{
    public class TreatiseonAlchemyTalisman : BaseTalisman
    {
        public override int LabelNumber { get { return 1073353; } } // Library Talisman - Treatise on Alchemy
        public override bool ForceShowName { get { return true; } }

        [Constructable]
        public TreatiseonAlchemyTalisman() : base(0x2F58)
        {
            Skill = SkillName.Alchemy;
            SuccessBonus = 30;
            Blessed = RandomTalisman.GetRandomBlessed();

            Attributes.EnhancePotions = 35;
            SkillBonuses.SetValues(0, SkillName.Magery, 10.0);
        }

        public TreatiseonAlchemyTalisman(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }

    public class PrimerOnArmsTalisman : BaseTalisman
    {
        public override int LabelNumber { get { return 1073354; } } // Library Talisman - A Primer on Arms
        public override bool ForceShowName { get { return true; } }

        [Constructable]
        public PrimerOnArmsTalisman() : base(0x2F59)
        {
            Blessed = RandomTalisman.GetRandomBlessed();

            Attributes.BonusStr = 10;
            Attributes.RegenHits = 5;
            Attributes.WeaponDamage = 25;
        }

        public PrimerOnArmsTalisman(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }

    public class MyBookTalisman : BaseTalisman
    {
        public override int LabelNumber { get { return 1073355; } } // Library Talisman - My Book
        public override bool ForceShowName { get { return true; } }

        [Constructable]
        public MyBookTalisman() : base(0x2F5A)
        {
            Blessed = RandomTalisman.GetRandomBlessed();

            Skill = SkillName.Inscribe;
            SuccessBonus = 30;
            ExceptionalBonus = 30;

            Attributes.BonusInt = 10;
            Attributes.BonusMana = 30;
        }

        public MyBookTalisman(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }

    public class TalkingtoWispsTalisman : BaseTalisman
    {
        public override int LabelNumber { get { return 1073356; } } // Library Talisman - Talking to Wisps
        public override bool ForceShowName { get { return true; } }

        [Constructable]
        public TalkingtoWispsTalisman() : base(0x2F5B)
        {
            Blessed = RandomTalisman.GetRandomBlessed();

            SkillBonuses.SetValues(0, SkillName.SpiritSpeak, 10.0);
            SkillBonuses.SetValues(1, SkillName.EvalInt, 10.0);
        }

        public TalkingtoWispsTalisman(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }

    public class GrammarOfOrchishTalisman : BaseTalisman
    {
        private DateTime m_NextSpecial;

        public override int LabelNumber { get { return 1073358; } } // Library Talisman - a Grammar of Orchish (Summoner)
        public override bool ForceShowName { get { return true; } }

        [Constructable]
        public GrammarOfOrchishTalisman() : base(0x2F59)
        {
            Blessed = RandomTalisman.GetRandomBlessed();
            Protection = RandomTalisman.GetRandomProtection();
            Summoner = new TalismanAttribute(typeof(SummonedOrcBrute), 0, 1072414);

            SkillBonuses.SetValues(0, SkillName.MagicResist, 10.0);
            SkillBonuses.SetValues(1, SkillName.Anatomy, 10.0);
        }

        public void Summon(Mobile attacker, Mobile defender)
        {
            if (attacker == null || defender == null || DateTime.Now < m_NextSpecial)
                return;

            Map map = defender.Map;

            if (map == null)
                return;

            m_NextSpecial = DateTime.Now + TimeSpan.FromSeconds(10.0);
            SumSkeleton summon = new SumSkeleton();

            bool validLocation = false;
            Point3D loc = defender.Location;

            for (int j = 0; !validLocation && j < 10; ++j)
            {
                int x = defender.X + Utility.Random(2) + 1;
                int y = defender.Y + Utility.Random(2) + 1;
                int z = map.GetAverageZ(x, y);

                if (validLocation = (map.CanFit(x, y, defender.Z, 16, false, false) && attacker.InLOS(new Point3D(x, y, defender.Z))))
                    loc = new Point3D(x, y, defender.Z);
                else if (validLocation = (map.CanFit(x, y, z, 16, false, false) && attacker.InLOS(new Point3D(x, y, z))))
                    loc = new Point3D(x, y, z);
            }

            summon.Hue = 0x4001;
            summon.Name = "an orcish warrior ghost";
            summon.Body = 138;
            summon.BaseSoundID = 0x45A;

            summon.SetStr(700, 800);
            summon.SetDex(100, 150);
            summon.SetInt(61, 85);

            summon.SetHits(1000, 1000);

            summon.SetDamage(17, 25);

            summon.SetDamageType(ResistanceType.Physical, 100);

            summon.SetResistance(ResistanceType.Physical, 80, 90);
            summon.SetResistance(ResistanceType.Fire, 80, 90);
            summon.SetResistance(ResistanceType.Cold, 80, 90);
            summon.SetResistance(ResistanceType.Poison, 80, 90);
            summon.SetResistance(ResistanceType.Energy, 80, 90);

            summon.SetSkill(SkillName.MagicResist, 70.1, 85.0);
            summon.SetSkill(SkillName.Swords, 115.1, 120.0);
            summon.SetSkill(SkillName.Tactics, 115.1, 125.0);
            summon.SetSkill(SkillName.Wrestling, 115.1, 120.0);

            summon.MoveToWorld(loc, map);
            Effects.PlaySound(loc, map, 0x45A);
            summon.Combatant = attacker;
            summon.ControlSlots = 0;
            summon.Summoned = true;
            summon.SummonMaster = defender;

            TimeSpan duration = TimeSpan.FromSeconds(50.0);

            new UnsummonTimer(defender, summon, duration).Start();
            summon.SummonEnd = DateTime.Now + duration;
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);

            list.Add("<basefont color=Yellow>Summon Orcish Warrior Ghosts<basefont color=White>");
        }

        public GrammarOfOrchishTalisman(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }

    public class BirdsofBritanniaTalisman : BaseTalisman
    {
        public override int LabelNumber { get { return 1073359; } } // Library Talisman - Birds of Britannia
        public override bool ForceShowName { get { return true; } }

        [Constructable]
        public BirdsofBritanniaTalisman() : base(0x2F5A)
        {
            Blessed = RandomTalisman.GetRandomBlessed();
            Slayer = TalismanSlayerName.Bird;

            SkillBonuses.SetValues(0, SkillName.AnimalTaming, 10.0);
            SkillBonuses.SetValues(1, SkillName.AnimalLore, 10.0);
        }

        public BirdsofBritanniaTalisman(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }

    public class TheLifeOfTravelingMinstrelTalisman : BaseTalisman
    {
        public override int LabelNumber { get { return 1073360; } } // Library Talisman - The Life of a Traveling Minstrel
        public override bool ForceShowName { get { return true; } }

        [Constructable]
        public TheLifeOfTravelingMinstrelTalisman() : base(0x2F5B)
        {
            Blessed = RandomTalisman.GetRandomBlessed();
            Protection = RandomTalisman.GetRandomProtection();

            SkillBonuses.SetValues(0, SkillName.Provocation, 10.0);
            SkillBonuses.SetValues(1, SkillName.Musicianship, 10.0);
        }

        public TheLifeOfTravelingMinstrelTalisman(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }
}