using System;
using Server;
using Server.Mobiles;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class TheBait : BaseTalisman
	{
		public override bool ForceShowName{ get{ return true; } }
		
		[Constructable]
		public TheBait() : base( 0x2F5A )
		{
			Hue = Utility.RandomMinMax( 1361, 1366 );
			Name = "<basefont color=#3366FF>The Bait";
			Blessed = RandomTalisman.GetRandomBlessed();
			Protection = new TalismanAttribute( typeof( SumPoisonElemental ), 30, "Saltwater Blob" );
			Killer = new TalismanAttribute( typeof( SaltwaterElemental ), Utility.RandomMinMax( 20, 50 ), "Saltwater Elemental" );
         Slayer = TalismanSlayerName.Ice;
			MaxChargeTime = 1800;
			MaxCharges = 10;
			Charges = MaxCharges;
			Summoner = new TalismanAttribute( typeof( MessageInABottle ), 1, 1041080 );
			
			Skill = SkillName.Cartography;
			SuccessBonus = Utility.RandomMinMax( 30, 40 );
			
			SkillBonuses.SetValues( 0, SkillName.Fishing, 15.0 );
			SkillBonuses.SetValues( 1, SkillName.Anatomy, 15.0 );
			SkillBonuses.SetValues( 2, SkillName.EvalInt, 15.0 );
			Attributes.Luck = 250;
			Attributes.BonusHits = 20;
			Attributes.BonusMana = 20;
			Attributes.DefendChance = 30;
			Attributes.SpellDamage = 20;
			Attributes.EnhancePotions = 25;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#3366FF>Immunity to freezing cold\nExtra item from Saltwater elemental<basefont color=White>" );
		}
		
		public TheBait( Serial serial ) :  base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
