using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
    public class WisdomOfAncientForest : BaseTalisman
    {
        public override bool ForceShowName { get { return true; } }

        [Constructable]
        public WisdomOfAncientForest() : base(0x2F5A)
        {
            bool flawless = Utility.RandomBool();

            Name = flawless ? "Wisdom Of Ancient Forest [Flawless]" : "Wisdom Of Ancient Forest";

            if (flawless)
            {
                Protection = new TalismanAttribute(typeof(SpiderKing), Utility.RandomMinMax(15, 40), "Spider King");
                Killer = new TalismanAttribute(typeof(Medusa), 50, "Medusa");
                MaxCharges = 250;
                Hue = 2126;

                SkillBonuses.SetValues(1, SkillName.Anatomy, 15.0);
                SkillBonuses.SetValues(2, SkillName.Archery, 15.0);

                Attributes.RegenStam = 3;
                Attributes.BonusStam = 15;
                Attributes.BonusDex = 10;
                Attributes.AttackChance = 10;
                Attributes.WeaponDamage = 20;
                Attributes.ReflectPhysical = 25;
            }
            else
            {
                Blessed = RandomTalisman.GetRandomBlessed();
                Protection = new TalismanAttribute(typeof(ForestElf), Utility.RandomMinMax(15, 40), "Forest Elf");
                Killer = new TalismanAttribute(typeof(Reaper), 50, 1018139);
                MaxCharges = Utility.RandomMinMax(40, 60);
                Hue = 2127;
            }

            Slayer = TalismanSlayerName.Bear;
            MaxChargeTime = 1800;
            Charges = MaxCharges;
            Summoner = new TalismanAttribute(typeof(Arrow), 100, 1023904);

            Skill = SkillName.Fletching;
            ExceptionalBonus = Utility.RandomMinMax(15, 30);
            SuccessBonus = Utility.RandomMinMax(15, 30);

            Attributes.BonusStam = 30;

            SkillBonuses.SetValues(0, SkillName.Tracking, 15.0);
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);

            list.Add("<basefont color=#9999FF>Spider King Web Protection\nMedusa stone Gaze Protection<basefont color=White>");
        }

        public WisdomOfAncientForest(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)1); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            if (version == 0)
                SkillBonuses.SetValues(0, SkillName.Tracking, 15.0);
        }
    }
}
