using System;

namespace Server.Items
{
	public class Switch : Item, ICommodity
	{
		public override int LabelNumber{ get{ return 1073464; } } // Switch
		
		string ICommodity.Description
		{
			get
			{
				return String.Format( "{0} switch", Amount );
			}
		}
		
		[Constructable]
		public Switch() : this( 1 )
		{
		}
	
		[Constructable]
		public Switch( int amount ) : base( 0x2F5F )
		{
			Weight = 1;
			Stackable = true;
			Amount = amount;
		}

		public Switch( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}

