using System; 
using Server; 
using Server.Items; 

namespace Server.Items 
{ 
	[FlipableAttribute( 0x13B2, 0x13B1 )]
	public class PoisonBow : MagicRanged
	{
		public override int EffectID{ get{return 0x1FA3; } }
		public override int EffectHue{ get{ return (this.Hue - 1); } }
		public override int DefHitSound{ get{ return 0x354; } }
		public override int DefMissSound{ get{ return 0x238; } }

		public override int AosStrengthReq{ get{ return 30; } }
		public override int AosMinDamage{ get{ return 16; } }
		public override int AosMaxDamage{ get{return 19; } }
		public override int AosSpeed{ get{return 30; } }

		public override int OldStrengthReq{ get{ return 20; } }
		public override int OldMinDamage{ get{return 11; } }
		public override int OldMaxDamage{ get{return 20; } }
		public override int OldSpeed{ get{return 30; } }

		public override int DefMaxRange{ get{return 11; } }
  		public override int InitMinHits{ get{ return 125; } }
  		public override int InitMaxHits{ get{ return 125; } }

		public override WeaponAnimation DefAnimation{ get{ return WeaponAnimation.ShootBow; } }

		public override void GetDamageTypes( Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy )
		{
			phys = nrgy = cold = fire = 0;
			pois = 100;
		}

		[Constructable]
		public PoisonBow() : base( 0x13B2 )
		{

			Name = "Poison Bow";
			Hue = 1272;
			Weight = 6.0;
			Layer = Layer.TwoHanded;
		}

		public PoisonBow( Serial serial ) : base( serial )
		{

		}

		public override bool AllowEquipedCast( Mobile from )
		{
			return true;
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			if ( Weight == 7.0 )
				Weight = 6.0;
		}
	}
}
