using System;
using Server.Network;
using Server.Items;

namespace Server.Items
{
	public class Eradicator : LevelCrossbow
	{
		public override int AosMinDamage{ get{ return 18; } }
		public override int AosMaxDamage{ get{ return 22; } }
		public override int AosSpeed{ get{ return 24; } }
		
		public override int ArtifactRarity{ get{ return 75; } }

		public override int DefMaxRange{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public Eradicator()
		{
			Weight = 5.0;
			Layer = Layer.TwoHanded;
			Name = "eradicator";
			Hue = 2640;
		}
		
		public override void GetDamageTypes(Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy)
		{
			cold = phys = 40;
         fire = 20;
         nrgy = pois = 0;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>+70% damage against mortal strike\nDouble Concussion Blow damage\nFree charm of cold snap use<basefont color=White>" );
		}

		public Eradicator( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}