using System;
using Server;
using Server.Engines.Harvest;
using Server.Mobiles;
using System.Collections;

namespace Server.Items
{
	public class LegendaryHatchet : LegendaryPickaxe
	{
		public override HarvestSystem HarvestSystem{ get{ return Lumberjacking.System; } }
		public override int ArtifactRarity{ get{ return 68; } }

		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.ArmorIgnore; } }
		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.Disarm; } }

		public override int AosStrengthReq{ get{ return 90; } }
		public override int AosMinDamage{ get{ return 15; } }
		public override int AosMaxDamage{ get{ return 22; } }
		public override int AosSpeed{ get{ return 38; } }

		public override int OldStrengthReq{ get{ return 25; } }
		public override int OldMinDamage{ get{ return 1; } }
		public override int OldMaxDamage{ get{ return 15; } }
		public override int OldSpeed{ get{ return 35; } }

		public override int DefHitSound{ get{ return 0x232; } }
		public override int DefMissSound{ get{ return 0x23A; } }

		public override SkillName DefSkill{ get{ return SkillName.Swords; } }
		public override WeaponType DefType{ get{ return WeaponType.Axe; } }
		public override WeaponAnimation DefAnimation{ get{ return WeaponAnimation.Slash2H; } }
		
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		
		[Constructable]
		public LegendaryHatchet()
		{
			ItemID = 0xF44;
         Name = "<basefont color=#CD853F>FORRESTBANE <basefont color=Yellow>[Legendary Hatchet]";
         Weight = 6.0;
			Hue = 2643;
			ShowUsesRemaining = false;
			Quality = WeaponQuality.Exceptional;
			
			Attributes.WeaponDamage = 15;
			Attributes.AttackChance = 15;
			Attributes.DefendChance = 25;
			Attributes.BonusStam = 12;
			Attributes.Luck = 200;
			Attributes.BonusHits = 10;
			WeaponAttributes.SelfRepair = 10;
			Slayer = SlayerName.ElementalBan;
			
			SkillBonuses.SetValues( 0, SkillName.Lumberjacking, 10.0 );
			SkillBonuses.SetValues( 1, SkillName.Swords, 10.0 );
			SkillBonuses.SetValues( 2, SkillName.Tactics, 10.0 );
		}
      
      public bool HarvestCorpse( Mobile from, object toHarvest )
		{
         if ( toHarvest is Corpse && from != null )
         {
            Corpse corpse = (Corpse) toHarvest;
            
            if ( /*corpse.Killer != from || */corpse.Carved || corpse.Channeled )
               return false;
            else
            {
			      Item drop = null;
			      
               if ( corpse.Owner is AshTreefellow )
                  drop = new AshLog();
               else if ( corpse.Owner is BloodwoodTreefellow )
                  drop = new BloodwoodLog();
               else if ( corpse.Owner is CedarTreefellow )
                  drop = new CedarLog();
               else if ( corpse.Owner is ElderTreefellow )
                  drop = new HeartwoodLog();
               else if ( corpse.Owner is FrostwoodTreefellow )
                  drop = new FrostwoodLog();
               else if ( corpse.Owner is HeartwoodTreefellow )
                  drop = new HeartwoodLog();
               else if ( corpse.Owner is CherryTreefellow )
                  drop = new CherryLog();
               else if ( corpse.Owner is MahoganeyTreefellow )
                  drop = new MahoganyLog();
               else if ( corpse.Owner is PineTreefellow )
                  drop = new PineLog();
               else if ( corpse.Owner is OakTreefellow )
                  drop = new OakLog();
               else if ( corpse.Owner is YewTreefellow )
                  drop = new YewLog();
               else if ( corpse.Owner is Treefellow || corpse.Owner is Reaper || corpse.Owner is Quagmire
                  || corpse.Owner is WhippingVine || corpse.Owner is Corpser || corpse.Owner is SwampTentacle 
                  || corpse.Owner is BogThing )
                  drop = new Log();
               else
                  return false;
               
               drop.Amount = Utility.RandomMinMax ( 6, 12 );
               
               corpse.DropItem( drop );
               from.SendMessage( "Podarilo se ti ziskat nekolik kusu dreva" );
               
               HarvestSystem.DoHarvestingEffect( from, this, Lumberjacking.System.Definition, corpse.Map, corpse.Location );
               HarvestSystem.DoHarvestingSound( from, this, Lumberjacking.System.Definition, toHarvest );
               
					if ( Utility.RandomDouble() < 0.035 )
					{
						from.AddToBackpack( (Item)Activator.CreateInstance( ASoullessBlade.ExtraLoot[Utility.Random(ASoullessBlade.ExtraLoot.Length)] ) );
                  from.SendMessage( 61, "Podarilo se ti najit specialni predmet" );
                  from.PlaySound( 0x3D );
               }
                  
               corpse.Carved = true;
					corpse.Channeled = true;
					corpse.Hue = 0x835;
               return true;
            }
         }
         else
            return false;
      }

		public LegendaryHatchet( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}