using System;
using Server;
using Server.Engines.Harvest;
using Server.Mobiles;
using System.Collections;

namespace Server.Items
{
	public class LegendaryPickaxe : BaseLevelAxe
	{
		public override HarvestSystem HarvestSystem{ get{ return Mining.System; } }
		public override int ArtifactRarity{ get{ return 68; } }

		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.DoubleStrike; } }
		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.Disarm; } }

		public override int AosStrengthReq{ get{ return 90; } }
		public override int AosMinDamage{ get{ return 15; } }
		public override int AosMaxDamage{ get{ return 22; } }
		public override int AosSpeed{ get{ return 38; } }

		public override int OldStrengthReq{ get{ return 25; } }
		public override int OldMinDamage{ get{ return 1; } }
		public override int OldMaxDamage{ get{ return 15; } }
		public override int OldSpeed{ get{ return 35; } }

		public override WeaponAnimation DefAnimation{ get{ return WeaponAnimation.Slash1H; } }
		public override int DefHitSound{ get{ return Utility.RandomList( 0x125, 0x126 ); } }
		
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		
		[Constructable]
		public LegendaryPickaxe() : base( 0xE86 )
		{
			Name = "<basefont color=#CD853F>EARTHSHATTER <basefont color=Yellow>[Legendary Pickaxe]";
         Weight = 8.0;
			Hue = 2643;
			ShowUsesRemaining = false;
			Quality = WeaponQuality.Exceptional;
			
			Attributes.WeaponDamage = 15;
			Attributes.AttackChance = 15;
			Attributes.DefendChance = 25;
			Attributes.BonusStam = 12;
			Attributes.Luck = 200;
			Attributes.BonusHits = 10;
			WeaponAttributes.SelfRepair = 10;
			Slayer = SlayerName.ElementalBan;
			
			SkillBonuses.SetValues( 0, SkillName.Mining, 10.0 );
			SkillBonuses.SetValues( 1, SkillName.Swords, 10.0 );
			SkillBonuses.SetValues( 2, SkillName.Tactics, 10.0 );
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			if ( this is LegendaryHatchet )
			   list.Add( "<basefont color=#CD853F>Unbreakable troll's axe\nSummon quagmire\nAllow harvest treefellow corpses\nLeveling by lumberjacking<basefont color=White>" );
         else
            list.Add( "<basefont color=#CD853F>Unbreakable gargoyles pickaxe\nSummon earth elemental\nAllow mine elemental corpses\nLeveling by mining<basefont color=White>" );
      }
		
		public override void OnHit(Mobile attacker, Mobile defender, double damageBonus)
		{
			if ( attacker.Player && !defender.Player && 0.05 > Utility.RandomDouble() )
				Summon( attacker, defender );
			
			base.OnHit( attacker, defender, damageBonus );
		}
		
		private void Summon( Mobile attacker, Mobile defender )
		{
			if ( attacker == null || defender == null )
				return;
			
			Map map = defender.Map;

			if ( map == null )
				return;

			SumDrake summon = new SumDrake();

			bool validLocation = false;
			Point3D loc = defender.Location;

			for ( int j = 0; !validLocation && j < 10; ++j )
			{
				int x = defender.X + Utility.Random( 2 ) + 1;
				int y = defender.Y + Utility.Random( 2 ) + 1;
				int z = map.GetAverageZ( x, y );

				if ( validLocation = ( map.CanFit( x, y, defender.Z, 16, false, false ) && attacker.InLOS( new Point3D(x, y, defender.Z) ) ) )
					loc = new Point3D( x, y, defender.Z );
				else if ( validLocation = ( map.CanFit( x, y, z, 16, false, false ) && attacker.InLOS( new Point3D(x, y, z) ) ) )
					loc = new Point3D( x, y, z );
			}
			
			Effects.PlaySound(loc, map, 0x2F3);//earthquake  sound
			
			if ( this is LegendaryHatchet )
			{
			   summon.Name = "a quagmire";
			   summon.Body = 789;
			   summon.BaseSoundID = 352;
         }
         else
         {
			   summon.Name = "an earth elemental";
			   summon.Body = 14;
			   summon.BaseSoundID = 268;
         }

			summon.Combatant = defender;
			summon.ControlSlots = 0;
			summon.Summoned = true;
			summon.SummonMaster = attacker;
			summon.MoveToWorld( loc, map );
			
			ZoogiVejce.EffectCircle( defender.Location, map, 3, 0x376A );
		}
      
      public bool MineCorpse( Mobile from, object toHarvest )
		{
         if ( toHarvest is Corpse && from != null )
         {
            Corpse corpse = (Corpse) toHarvest;
            
            if ( /*corpse.Killer != from || */corpse.Carved || corpse.Channeled )
               return false;
            else
            {
			      Item drop = null;
			      
               if ( corpse.Owner is DullCopperElemental )
                  drop = new DullCopperOre();
               else if ( corpse.Owner is CopperElemental )
                  drop = new CopperOre();
               else if ( corpse.Owner is BronzeElemental )
                  drop = new BronzeOre();
               else if ( corpse.Owner is ShadowIronElemental )
                  drop = new ShadowIronOre();
               else if ( corpse.Owner is GoldenElemental )
                  drop = new GoldOre();
               else if ( corpse.Owner is AgapiteElemental )
                  drop = new AgapiteOre();
               else if ( corpse.Owner is VeriteElemental )
                  drop = new VeriteOre();
               else if ( corpse.Owner is ValoriteElemental )
                  drop = new ValoriteOre();
               else if ( corpse.Owner is SilverElemental )
                  drop = new SilverOre();
               else if ( corpse.Owner is PlatinumElemental )
                  drop = new PlatinumOre();
               else if ( corpse.Owner is MythrilElemental )
                  drop = new MythrilOre();
               else if ( corpse.Owner is ObsidianElemental )
                  drop = new ObsidianOre();
               else if ( corpse.Owner is JadeElemental )
                  drop = new JadeOre();
               else if ( corpse.Owner is MoonstoneElemental )
                  drop = new MoonstoneOre();
               else if ( corpse.Owner is SunstoneElemental )
                  drop = new SunstoneOre();
               else if ( corpse.Owner is BloodstoneElemental )
                  drop = new BloodstoneOre();
               else if ( corpse.Owner is GiantEarthElemental || corpse.Owner is EarthElemental || corpse.Owner is SnowElemental
                  || corpse.Owner is AirElemental || corpse.Owner is BloodElemental || corpse.Owner is Efreet 
                  || corpse.Owner is FireElemental || corpse.Owner is IceElemental || corpse.Owner is PoisonElemental 
                  || corpse.Owner is ToxicElemental || corpse.Owner is WaterElemental || corpse.Owner is ElderFireElemental )
                  drop = new IronOre();
               else
                  return false;
               
               drop.Amount = Utility.RandomMinMax ( 4, 10 );
               
               corpse.DropItem( drop );
               from.SendMessage( "Podarilo se ti ziskat nekolik kusu rudy" );
               
               HarvestSystem.DoHarvestingEffect( from, this, Mining.System.OreAndStone, corpse.Map, corpse.Location );
               HarvestSystem.DoHarvestingSound( from, this, Mining.System.OreAndStone, toHarvest );
               
					if ( Utility.RandomDouble() < 0.03 )
					{
						from.AddToBackpack( (Item)Activator.CreateInstance( ASoullessBlade.ExtraLoot[Utility.Random(ASoullessBlade.ExtraLoot.Length)] ) );
                  from.SendMessage( 61, "Podarilo se ti najit specialni predmet" );
                  from.PlaySound( 0x3D );
               }
                  
               corpse.Carved = true;
					corpse.Channeled = true;
					corpse.Hue = 0x835;
               return true;
            }
         }
         else
            return false;
      }

		public LegendaryPickaxe( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}