using System;
using Server;

namespace Server.Items
{
	public class RazorClaws : Tekagi
	{
	 	public override int InitMinHits{ get{ return 125; } }
	 	public override int InitMaxHits{ get{ return 125; } }
		public override int AosMinDamage{ get{ return 17; } }
		public override int AosMaxDamage{ get{ return 21; } }
	 	
	 	[Constructable]
	 	public RazorClaws()
	 	{
	 	 	Name = "Razor Claws";
	 	 	Hue = 2628;
			Attributes.AttackChance = 22;
			Attributes.WeaponDamage = 20;
			Attributes.BonusDex = 5;
			Attributes.BonusHits = 10;
			Attributes.BonusStr = 5;
			Attributes.Luck = 150;
			Attributes.RegenHits = 3;
			Attributes.RegenStam = 4;
			Attributes.WeaponSpeed = 20;
			WeaponAttributes.HitLeechHits = 30;
			WeaponAttributes.HitLeechStam = 20;
			WeaponAttributes.HitLightning = 25;
			WeaponAttributes.HitLowerAttack = 25;
			WeaponAttributes.HitMagicArrow = 30;
			
			SkillBonuses.SetValues( 0, SkillName.Ninjitsu, 20.0 );
			SkillBonuses.SetValues( 1, SkillName.Tactics, 10.0 );
			SkillBonuses.SetValues( 2, SkillName.Anatomy, 10.0 );
	 	}
	 	
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>Dual Wield attack speed: 0.75 sec\nIncreased Talon Strike damage<basefont color=White>" );
		}

	 	public RazorClaws(Serial serial) : base( serial )
	 	{
	 	}

	 	public override void Serialize( GenericWriter writer )
	 	{
	 	 	base.Serialize( writer );

	 	 	writer.Write( (int) 0 );
	 	}
	 	public override void Deserialize(GenericReader reader)
	 	{
	 	 	base.Deserialize( reader );

	 	 	int version = reader.ReadInt();
	 	}
	}
}
