//////////////////////
//Created by KyleMan//
//////////////////////
using System;
using Server;

namespace Server.Items
{
	public class DeathAxe : ExecutionersAxe
	{
	 	public override int ArtifactRarity{ get{ return 90; } }
	 	public override int InitMinHits{ get{ return 125; } }
	 	public override int InitMaxHits{ get{ return 125; } }
	 	[Constructable]
	 	public DeathAxe()
	 	{
	 	 	Name = "Axe of Death";
	 	 	Hue = 1157;
	 	 	Attributes.SpellChanneling = 1;
	 	 	//Attributes.BonusStr = 10;
	 	 	Attributes.BonusHits = 5;
	 	 	Attributes.BonusInt = 10;
	 	 	//Attributes.BonusMana = 5;
	 	 	//Attributes.RegenHits = 5;
	 	 	Attributes.RegenMana = 5;
	 	 	Attributes.AttackChance = 20;
	 	 	Attributes.WeaponDamage = 50;
	 	 	Attributes.WeaponSpeed = 20;
	 	 	WeaponAttributes.HitFireArea = 30;
	 	 	WeaponAttributes.ResistFireBonus = 10;
	 	 	WeaponAttributes.DurabilityBonus = 70;
	 	 	WeaponAttributes.SelfRepair = 5;
	 	 	Attributes.CastSpeed = 2;
	 	 	//Attributes.CastRecovery = 1;
	 	 	WeaponAttributes.HitFireball = 50;
	 	}

	 	public DeathAxe(Serial serial) : base( serial )
	 	{
	 	}

	 	public override void Serialize( GenericWriter writer )
	 	{
	 	 	base.Serialize( writer );

	 	 	writer.Write( (int) 0 );
	 	}
	 	public override void Deserialize(GenericReader reader)
	 	{
	 	 	base.Deserialize( reader );

	 	 	int version = reader.ReadInt();
	 	}
	}
}
