using System;
using Server;

namespace Server.Items
{
	public class SparrowBlade : Katana 
	{
		public override int ArtifactRarity{ get{ return 90; } }
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public SparrowBlade()
		{
			Weight = 5.0;
         Name = "Sparrow's Blade";
         Hue = 1157;

			WeaponAttributes.HitLightning = 40;
			WeaponAttributes.HitHarm = 35;
			WeaponAttributes.HitLowerDefend = 35;

			Attributes.Luck = 300;
			Attributes.SpellChanneling = 1;
			Attributes.WeaponSpeed = 25;

			StrRequirement = 70;

			LootType = LootType.Regular;
		}

		public SparrowBlade( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}