using System;
using Server.Network;
using Server.Items;

namespace Server.Items
{
	public class TheCalamity : LevelHeavyCrossbow
	{
		public override int ArtifactRarity{ get{ return 75; } }
		
		public override int AosMinDamage{ get{ return 19; } }
		public override int AosMaxDamage{ get{ return 22; } }
		public override int AosSpeed{ get{ return 22; } }

		public override int DefMaxRange{ get{ return 10; } }

		public override int InitMinHits{ get{ return 255; } }
		public override int InitMaxHits{ get{ return 255; } }

		[Constructable]
		public TheCalamity()
		{
			Weight = 12.0;
			Layer = Layer.TwoHanded;
			Name = "the calamity";
			Hue = 2504;
         
         NewPrimaryAbility = WeaponAbility.AbilityType.ArmorIgnore;
         NewSecondaryAbility = WeaponAbility.AbilityType.DoubleStrike;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>Free charm of cold snap use<basefont color=White>" );
		}
		
		public override void GetDamageTypes( Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy )
		{
			pois = fire = phys = 0;
			nrgy = cold = 50;
		}

		public TheCalamity( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
         
         if ( version == 0 )
         {
            NewPrimaryAbility = WeaponAbility.AbilityType.ArmorIgnore;
            NewSecondaryAbility = WeaponAbility.AbilityType.DoubleStrike;
         }         
		}
	}
}