using System;
using Server;
using Server.Network;
using System.Collections;
using Server.Mobiles;
using Server.Misc;

namespace Server.Items
{
    public class TorchWeapon : BaseBashing
    {
        private LightSource light;
        private DateTime m_NextUse;
        public override WeaponAbility PrimaryAbility { get { return WeaponAbility.Disarm; } }
        public override WeaponAbility SecondaryAbility { get { return WeaponAbility.ParalyzingBlow; } }

        public override int ArtifactRarity { get { return 77; } }

        public override WeaponAnimation DefAnimation { get { return WeaponAnimation.Slash2H; } }

        public override int AosStrengthReq { get { return 35; } }
        public override int AosMinDamage { get { return 12; } }
        public override int AosMaxDamage { get { return 14; } }
        public override int AosSpeed { get { return 40; } }

        public override int OldStrengthReq { get { return 35; } }
        public override int OldMinDamage { get { return 6; } }
        public override int OldMaxDamage { get { return 33; } }
        public override int OldSpeed { get { return 30; } }

        public override int InitMinHits { get { return 125; } }
        public override int InitMaxHits { get { return 125; } }

        public override int DefHitSound { get { return 0x54; } }
        public override int DefMissSound { get { return 0x4BB; } }

        [Constructable]
        public TorchWeapon()
            : base(0xF6B)
        {
            Name = "Torch of Living Dead Slaughter";
            Weight = 1.0;
            Hue = 0;
            Layer = Layer.TwoHanded;
            Light = LightType.Circle300;
            WeaponAttributes.ResistFireBonus = 12;
            Slayer = SlayerName.Silver;
            Attributes.WeaponDamage = 35;
            Attributes.AttackChance = 15;
            WeaponAttributes.HitFireball = 40;
            WeaponAttributes.HitLeechMana = 20;
            WeaponAttributes.HitLeechHits = 20;
            WeaponAttributes.HitLeechStam = 20;
        }

        public override bool OnEquip(Mobile from)
        {
            ItemID = 0xA12;
            light = new LightSource();
            light.Layer = Layer.Unused_xF;
            light.Light = LightType.Circle300;

            from.AddItem(light);
            Mobiles.ElderTreefellow.StopEffect(from, true);

            return base.OnEquip(from);
        }

        public override void OnRemoved(object parent)
        {
            ItemID = 0xF6B;

            if (light != null && parent is Mobile)
            {
                light.Delete();
            }
            base.OnRemoved(parent);
        }

        public override void OnDoubleClick(Mobile from)
        {
            if (Parent != from)
            {
                from.SendMessage("Musis louc drzet v ruce pro uvolneni energie!");
            }
            else if (from.Mana != from.ManaMax)
            {
                from.SendMessage("Musis mit maximum dusevni energie pro uvolneni energie!");
            }
            else if (m_NextUse < DateTime.Now)
            {
                m_NextUse = DateTime.Now + TimeSpan.FromMinutes(2.0);
                DispelUndead(from);
                from.Mana = 0;
            }
            else
            {
                from.SendMessage("Jeste je prilis brzy pro uvolneni energie.");
            }
        }

        public void DispelUndead(Mobile holder)
        {
            ArrayList list = new ArrayList();
            SlayerEntry atkSlayer = SlayerGroup.GetEntryByName(SlayerName.Silver);

            foreach (Mobile m in holder.GetMobilesInRange(3))
            {
                if (m == holder || !holder.CanBeHarmful(m))
                    continue;

                if (atkSlayer != null && atkSlayer.Slays(m))
                    list.Add(m);
            }

            foreach (Mobile m in list)
            {
                holder.DoHarmful(m);

                m.FixedParticles(0x3709, 10, 30, 5052, EffectLayer.LeftFoot);
                m.PlaySound(0x208);
                m.Damage(Utility.Random(60, 80), holder);
            }
            holder.SendMessage("Energie byla uvolnena.");
        }

        // 		public override void OnHit( Mobile attacker, Mobile defender )
        // 		{
        // 			attacker.MovingEffect( defender, 14068, 3, 3, false, false );
        // 			defender.FixedParticles( 14089, 10, 30, 5052, EffectLayer.LeftFoot );
        // 			OnHit( attacker, defender, 1.0 );
        // 		}

        public override void GetDamageTypes(Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy)
        {
            fire = 100;
            cold = phys = pois = nrgy = 0;
        }

        // 		public override bool Dye( Mobile from, DyeTub sender )
        // 		{
        // 			from.SendLocalizedMessage( sender.FailMessage );
        // 			return false;
        // 		}

        public TorchWeapon(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
            writer.Write(light);

        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
            light = reader.ReadItem() as LightSource;

        }
    }
}