using System;
using Server.Items;
using Server.Gumps;
using Server.Network;

namespace Server.Items
{
	[FlipableAttribute( 4466, 4465 )]
	public class WebStone : Item
	{
		private string i_url_1 = "http://auberon.stranky.org/";
		private string i_name_1 = "Auberon stranky";
		private string i_url_2 = "http://auberon.stranky.org/forum/";
		private string i_name_2 = "Auberon forum";
		private string i_url_3 = "http://auberon.stranky.org/kompendium.php";
		private string i_name_3 = "Kompendium";
		private string i_url_4 = "http://auberon.stranky.org/pravidla.php";
		private string i_name_4 = "Pravidla";
		private string i_url_5 = "http://uo.stratics.com";
		private string i_name_5 = "Vse o Ultime Online";
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string URL_1
		{
			get { return i_url_1; }
			set { i_url_1 = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string name_1
		{
			get { return i_name_1; }
			set { name_1 = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string URL_2
		{
			get { return i_url_2; }
			set { i_url_2 = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string name_2
		{
			get { return i_name_2; }
			set { name_2 = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string URL_3
		{
			get { return i_url_3; }
			set { i_url_3 = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string name_3
		{
			get { return i_name_3; }
			set { name_3 = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string URL_4
		{
			get { return i_url_4; }
			set { i_url_4 = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string name_4
		{
			get { return i_name_4; }
			set { name_4 = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string URL_5
		{
			get { return i_url_5; }
			set { i_url_5 = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string name_5
		{
			get { return i_name_5; }
			set { name_5 = value; }
		}

		[Constructable]
		public WebStone() : base( 4466 )
		{
			Name = "Web Stone";
			Hue = 1166;
			Movable = false;
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( i_url_1 != null && i_url_2 != null && i_url_3 != null && i_url_4 != null && i_url_5 != null )
			{
				if ( !from.InRange( this.GetWorldLocation(), 4 ) )
					from.SendLocalizedMessage( 502138 );
				else
					from.SendGump( new WebStoneGump( from, this ) );
			}
		}

		public override void OnSingleClick( Mobile from )
		{
			this.LabelTo( from, this.Name );
		}
		
		public WebStone( Serial serial ) : base( serial )
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize( writer );
			writer.Write( (int) 1 );
			writer.Write( i_url_1 );
			writer.Write( i_name_1 );
			writer.Write( i_url_2 );
			writer.Write( i_name_2 );
			writer.Write( i_url_3 );
			writer.Write( i_name_3 );
			writer.Write( i_url_4 );
			writer.Write( i_name_4 );
			writer.Write( i_url_5 );
			writer.Write( i_name_5 );
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			switch ( version )
			{
				case 1:
					{
						i_url_1 = reader.ReadString();
						i_name_1 = reader.ReadString();
						i_url_2 = reader.ReadString();
						i_name_2 = reader.ReadString();
						i_url_3 = reader.ReadString();
						i_name_3 = reader.ReadString();
						i_url_4 = reader.ReadString();
						i_name_4 = reader.ReadString();
						i_url_5 = reader.ReadString();
						i_name_5 = reader.ReadString();
						break;
					}
			}
		}
	}

	public class WebStoneGump : Gump
	{
		private WebStone m_ws;
		
		public WebStoneGump( Mobile owner,  WebStone ws) : base( 50, 50 )
		{
			owner.CloseGump( typeof( WebStoneGump ) );
			m_ws = ws;

			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			this.AddPage(0);
			this.AddBackground(0, 0, 246, 174, 5054);
			this.AddImageTiled(8, 8, 197, 21, 2624);
			this.AddAlphaRegion(8, 8, 197, 21);
			this.AddHtml(8, 8, 197, 21, "<BASEFONT COLOR=#8080FF><CENTER>Webove stranky</CENTER></BASEFONT>", false, false);
			this.AddImageTiled(38, 33, 199, 133, 2624);
			this.AddAlphaRegion(38, 33, 199, 133);
			this.AddButton(207, 8, 4017, 4019, 0, GumpButtonType.Reply, 0);
			this.AddButton(8, 40, 4005, 4007, 1, GumpButtonType.Reply, 0);
			this.AddButton(8, 62, 4005, 4007, 2, GumpButtonType.Reply, 0);
			this.AddButton(8, 84, 4005, 4007, 3, GumpButtonType.Reply, 0);
			this.AddButton(8, 106, 4005, 4007, 4, GumpButtonType.Reply, 0);
			this.AddButton(8, 135, 4005, 4007, 5, GumpButtonType.Reply, 0);
			this.AddLabel(50, 41, 0x480, m_ws.name_1);
			this.AddLabel(50, 63, 0x480, m_ws.name_2);
			this.AddLabel(50, 85, 0x480, m_ws.name_3);
			this.AddLabel(50, 107, 0x480, m_ws.name_4);
			this.AddLabel(50, 136, 0x480, m_ws.name_5);

		}

		public override void OnResponse( NetState state, RelayInfo info )
		{
			switch (info.ButtonID)
			{
				case 0: // close
					{
						break;
					}
				case 1:
					{
						state.Mobile.LaunchBrowser( m_ws.URL_1 );
						break;
					}
				case 2:
					{
						state.Mobile.LaunchBrowser( m_ws.URL_2 );
						break;
					}
				case 3:
					{
						state.Mobile.LaunchBrowser( m_ws.URL_3 );
						break;
					}
				case 4:
					{
						state.Mobile.LaunchBrowser( m_ws.URL_4 );
						break;
					}
				case 5:
					{
						state.Mobile.LaunchBrowser( m_ws.URL_5 );
						break;
					}
			}
		}
	}
}
