using System;
using System.Collections;
using Server;
using Server.Prompts;
using Server.Mobiles;
using Server.ContextMenus;
using Server.Gumps;
using Server.Items;
using Server.Network;
using Server.Targeting;

namespace Server.Items
{
	public class TokenBox : BaseContainer
	{
		private int m_Token;
		private Mobile m_Owner;
		
		public override bool DisplaysContent{ get{ return false; } }
      public override bool DisplayWeight { get { return true; } }
      
		[CommandProperty(AccessLevel.GameMaster)]
		public int Token { get { return m_Token; } set { m_Token = value; InvalidateProperties(); } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public Mobile Owner
		{
			get{ return m_Owner; }
			set{ m_Owner = value; }
		}
		
		[Constructable]
		public TokenBox() : base( 0x2252 )
		{
			Movable = true;
			Weight = 0.5;
			Name = "Kniha na stribro";
			LootType = LootType.Blessed;
			Hue = 2220;
		}
		
		[Constructable]
		public TokenBox( Mobile m ) : base( 0x2252 )
		{
			Movable = true;
			Weight = 0;
			Name = "Kniha na stribro";
			LootType = LootType.Blessed;
			m_Owner = m;
			Hue = 2220;
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( m_Owner == null )
			{
				Mobile mobile = (Mobile)from;
				PlayerMobile pm = (PlayerMobile)from;

				Owner = pm;
			}
			if ( from != m_Owner )
			{
				from.SendMessage( "Tato kniha neni tvoje!" );
			}
			else if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			}
			else if ( from is PlayerMobile )
			{
				from.SendGump( new TokenBoxGump( (PlayerMobile)from, this ) );
			}
		}
		
		public override bool OnDragDrop( Mobile from, Item dropped )
		{
			if ( dropped is Tokens )
			{
				
				if ( Token >= 200000000 )
				{
					from.SendMessage( "Kniha je plna" );
					return false;
				}
				else
				{
					Item curItem = dropped as Item;
					Token += curItem.Amount;
					curItem.Delete();
					from.CloseGump(typeof(TokenBoxGump));
					//          from.SendGump( new CheckBookGump( (PlayerMobile)from, this ) );
					return true;
				}
			}
			
			if ( dropped is TokenCheck )
			{
				
				if ( Token >= 200000000 )
				{
					from.SendMessage( "Kniha je plna" );
					return false;
				}
				else
				{
					Token = ( Token + ((TokenCheck)dropped).Worth );
					((Item)dropped).Delete();
					from.CloseGump(typeof(TokenBoxGump));
					//          from.SendGump( new CheckBookGump( (PlayerMobile)from, this ) );
					return true;
				}
			}
			return false;
		}
		

		public void BeginCombine( Mobile from )
		{
			from.Target = new TokenBoxTarget( this );
		}

		public void EndCombine( Mobile from, object o )
		{
			if ( o is Item && ((Item)o).IsChildOf( from.Backpack ) )
			{
				if (!( o is Tokens || o is TokenCheck ))
				{
					from.SendMessage( "Tento predmet nemuzes do knihy vlozit." );
				}
				if ( o is Tokens  )
				{

					if ( Token >= 200000000 )
						from.SendMessage( "Kniha je plna" );
					else
					{
						Item curItem = o as Item;
						Token += curItem.Amount;
						curItem.Delete();
						from.SendGump( new TokenBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				
				if ( o is TokenCheck )
				{
					if ( Token >= (200000000 - ((TokenCheck)o).Worth) )
						from.SendMessage( "Kniha je plna" );
					else
					{
						Token = ( Token + ((TokenCheck)o).Worth );
						((Item)o).Delete();
						from.SendGump( new TokenBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
			}
			else
			{
				from.SendLocalizedMessage( 1045158 ); // You must have the item in your backpack to target it.
			}
		}

		public TokenBox( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) m_Token);
			writer.Write( ( Mobile ) m_Owner);
			
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			m_Token = reader.ReadInt();
			m_Owner = reader.ReadMobile();
			
		}
	}
}

namespace Server.Gumps
{
	
	public class TokenBoxGump : Gump
	{
		
		private PlayerMobile m_From;
		private TokenBox m_Box;
		
		public TokenBoxGump( PlayerMobile from, Item item ): base( 0, 0 )
		{
			
			m_From = from;
			if (!(item is TokenBox))
				return;
			TokenBox box = item as TokenBox;
			m_Box = box;

			m_From.CloseGump( typeof( TokenBoxGump ) );
			
			//         this.Closable=true;
			//         this.Disposable=false;
			//         this.Dragable=true;
			//         this.Resizable=false;
			//         this.AddPage(0);
			//         this.AddBackground(110, 138, 261, 159, 9300);
			//         this.AddButton(120, 265, 1209, 1210, 1, GumpButtonType.Reply, 0);
			//         this.AddButton(120, 245, 1209, 1210, 2, GumpButtonType.Reply, 0);
			//         this.AddButton(120, 225, 1209, 1210, 3, GumpButtonType.Reply, 0);
			//         this.AddLabel(143, 260, 37, @"Vlozit Tokeny");
			//         this.AddLabel(143, 240, 67, @"Vybrat Tokeny");
			//         this.AddLabel(143, 220, 67, @"Vypsat sek");
			//         this.AddBackground(120, 200, 165, 20, 9300);
			//         this.AddTextEntry(123, 200, 155, 25, 1265, 1, "0");
			//         this.AddLabel(120, 160, 1160, @"Pocet Tokenu:");
			//         this.AddLabel(243, 160, 1160, box.Token.ToString());
			//         this.AddLabel(193, 142, 187, @"Kniha tokenu");
			//         this.AddButton(345, 144, 22150, 22151, 4, GumpButtonType.Reply, 0);
			//         this.AddLabel(120, 180, 67, @"Kolik vybrat tokenu?");
			//         this.AddItem(312, 247, 7187);
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			this.AddPage(0);
			this.AddBackground(71, 107, 332, 210, 83);
			this.AddImageTiled(79, 118, 316, 188, 2624);
			this.AddAlphaRegion(79, 118, 316, 188);
			this.AddButton(121, 270, 4005, 4007, 1, GumpButtonType.Reply, 0);
			this.AddButton(121, 243, 4026, 4028, 2, GumpButtonType.Reply, 0);
			this.AddButton(121, 216, 4014, 4016, 3, GumpButtonType.Reply, 0);
			this.AddLabel(160, 270, 2219, @"Vlozit Stribro");
			this.AddLabel(160, 244, 1152, @"Vybrat Stribro");
			this.AddLabel(160, 217, 1152, @"Vypsat Poukazku");
			this.AddLabel(121, 160, 1152, @"Pocet Stribrnych:");
			this.AddLabel(245, 160, 2219, box.Token.ToString() );
			this.AddLabel(156, 126, 2219, @"Kniha na stribrne mince");
			this.AddButton(359, 122, 4017, 4019, 4, GumpButtonType.Reply, 0);
			this.AddLabel(121, 188, 1152, @"Vyber:");
			this.AddImageTiled(171, 185, 123, 24, 2624);
			this.AddTextEntry(173, 188, 175, 22, 2219, 1, "0");
			this.AddItem(344, 261, 7187);

			
		}
		
		public override void OnResponse( NetState sender, RelayInfo info )
		{
			if ( m_Box.Deleted )
				return;
			
			if ( info.ButtonID == 1)
			{
				m_From.SendGump( new TokenBoxGump( m_From, m_Box ) );
				m_Box.BeginCombine( m_From );
			}
			
			if ( info.ButtonID == 2 )
			{
				TextRelay tr_TokenAmount = info.GetTextEntry( 1 );
				if(tr_TokenAmount != null)
				{
					int i_MaxAmount = 0;
					try
					{
						i_MaxAmount = Convert.ToInt32(tr_TokenAmount.Text,10);
					}
					catch
					{
						m_From.SendMessage(1161, "Je mozne zadat pouze cisla.");
					}
					if(i_MaxAmount > 0)
					{
						if (i_MaxAmount <= ((TokenBox)m_Box ).Token)
						{
							if (i_MaxAmount <= 60000)
							{
								m_From.AddToBackpack(new Tokens(i_MaxAmount));
								m_From.SendMessage(1161, "Z knihy bylo vybrano {0} stribrnych.", i_MaxAmount);
								((TokenBox)m_Box ).Token = (((TokenBox)m_Box ).Token - i_MaxAmount);
							}
							else
								m_From.SendMessage(1161, "Nelze vybrat vice nez 60,000 stribrnych najednou.");
						}
						else
							m_From.SendMessage(1173, "Nemas v knize tolik stribrnych");
					}
					m_From.SendGump( new TokenBoxGump( m_From, m_Box ) );
				}
			}
			
			if ( info.ButtonID == 3 )
			{
				TextRelay tr_TokenAmount = info.GetTextEntry( 1 );
				if(tr_TokenAmount != null)
				{
					int i_MaxAmount = 0;
					try
					{
						i_MaxAmount = Convert.ToInt32(tr_TokenAmount.Text,10);
					}
					catch
					{
						m_From.SendMessage(1161, "Je mozne zadat pouze cisla.");
					}
					if(i_MaxAmount > 0)
					{
						if (i_MaxAmount <= ((TokenBox)m_Box ).Token)
						{
							if (i_MaxAmount <= 1000000)
							{
								m_From.AddToBackpack(new TokenCheck(i_MaxAmount));
								m_From.SendMessage(1161, "Poukazka na {0} stribrnych byla umistena do tveho batohu.", i_MaxAmount);
								((TokenBox)m_Box ).Token = (((TokenBox)m_Box ).Token - i_MaxAmount);
							}
							else
								m_From.SendMessage(1161, "Nelze vypsat Poukazku na vice nez 1,000,000 stribrnych najednou.");
						}
						else
							m_From.SendMessage(1173, "Nemas v knize tolik stribrnych");
					}
					m_From.SendGump( new TokenBoxGump( m_From, m_Box ) );
				}
			}
		}
	}
}

namespace Server.Items
{
	public class TokenBoxTarget : Target
	{
		private TokenBox m_Box;

		public TokenBoxTarget( TokenBox box ) : base( 18, false, TargetFlags.None )
		{
			m_Box = box;
		}

		protected override void OnTarget( Mobile from, object targeted )
		{
			if ( m_Box.Deleted )
				return;

			m_Box.EndCombine( from, targeted );
		}
	}
}
