using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a banshee corpse" )]
	public class Banshee : BaseCreature
	{
		private DateTime m_HidingDelay = DateTime.Now;
		
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.MortalStrike;
		}

		[Constructable]
		public Banshee() : base( AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a banshee";
			Body = 310;
			BaseSoundID = 0x482;

			SetStr( 226, 350 );
			SetDex( 56, 80 );
			SetInt( 486, 510 );

			SetHits( 460, 500 );

			SetDamage( 15, 19 );

			SetDamageType( ResistanceType.Physical, 20 );
			SetDamageType( ResistanceType.Cold, 60 );
			SetDamageType( ResistanceType.Poison, 20 );

			SetResistance( ResistanceType.Physical, 50, 60 );
			SetResistance( ResistanceType.Fire, 20, 30 );
			SetResistance( ResistanceType.Cold, 70, 80 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 50, 60 );

			SetSkill( SkillName.MagicResist, 85.1, 90.0 );
			SetSkill( SkillName.EvalInt, 77.6, 87.5 );
			SetSkill( SkillName.Necromancy, 190.6, 220.5 );
			SetSkill( SkillName.SpiritSpeak, 90.1, 120.5 );
			SetSkill( SkillName.Magery, 190.1, 220.1);
			SetSkill( SkillName.Poisoning, 80.5 );
			SetSkill( SkillName.Meditation, 110.0 );
			SetSkill( SkillName.Tactics, 95.1, 120.0 );
			SetSkill( SkillName.Wrestling, 95.1, 120.0 );
			SetSkill( SkillName.Hiding, 100.1 );
			SetSkill( SkillName.Parry, 40.1, 60.0 );
			SetSkill( SkillName.Anatomy, 50.1, 90.0 );
			SetSkill( SkillName.DetectHidden, 100.1, 120.0 );
			SetSkill( SkillName.Stealth, 300.0 );

			Fame = 13500;
			Karma = -5500;

			VirtualArmor = 39;
			
			PackItem( Loot.RandomNewPotion() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
			AddLoot( LootPack.FilthyRich, 2 );
		}

		public override void OnCombatantChange()
		{
			base.OnCombatantChange();

			if ( Hidden && Combatant != null )
				Combatant = null;
		}
		
		public override void OnThink()
		{
			m_HidingDelay = Ability.HideSelf( this, m_HidingDelay, Utility.RandomMinMax( 2, 5 ), 10 );
			// 			base.OnThink();
		}

		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
			damage = 0;
			from.SendMessage( "{0} nelze zranit zbrani.", this.Name );
		}

		public override bool BleedImmune{ get{ return true; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public Banshee( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
