using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a beholder corpse" )]
	public class Beholder : BaseCreature
	{
		private DateTime m_Delay = DateTime.Now;
		
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
					case 1: return WeaponAbility.WhirlwindAttack;
					case 2: return WeaponAbility.CrushingBlow;
			}
		}
		
		[Constructable]
		public Beholder () : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a beholder";
			Body = 22;
			BaseSoundID = 377;
			Hue = 1173;

			SetStr( 496, 625 );
			SetDex( 86, 105 );
			SetInt( 491, 685 );

			SetHits( 878, 1095 );

			SetDamage( 12, 25 );

			SetDamageType( ResistanceType.Physical, 50 );
			SetDamageType( ResistanceType.Energy, 50 );

			SetResistance( ResistanceType.Physical, 65, 75 );
			SetResistance( ResistanceType.Fire, 60, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 60, 70 );
			SetResistance( ResistanceType.Energy, 60, 70 );

			SetSkill( SkillName.Anatomy, 90.0, 115.0 );
			SetSkill( SkillName.EvalInt, 90.1, 115.0 );
			SetSkill( SkillName.Magery, 90.1, 115.0 );
			SetSkill( SkillName.MagicResist, 115.1, 130.0 );
			SetSkill( SkillName.Tactics, 90.1, 115.0 );
			SetSkill( SkillName.Wrestling, 90.1, 115.0 );

			Fame = 22500;
			Karma = -12500;

			VirtualArmor = 65;
			
			if (Utility.RandomDouble() < 0.0075)
			{
				PackItem( new Eyes() );
			}
		}

		public override int TreasureMapLevel{ get{ return Core.AOS ? 5 : 0; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
			AddLoot( LootPack.FilthyRich, 2 );
		}

		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
			
			if ( DateTime.Now > m_Delay )
			{
				Ability.Aura( this, 60, 90, 3, 6, 4, this.Name + " vypustil oblak jedovateho plynu.", true );
				m_Delay = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 20, 30 ) );
			}
			
			if ( Utility.RandomDouble() < 0.05 )
				Summon();

			// teleports player near
			if ( from is PlayerMobile && !InRange( from.Location, 1 ) && Utility.RandomDouble() < 0.1 )
			{
				Combatant = from;
				
				from.MoveToWorld( Location, Map );
				from.FixedParticles( 0x376A, 9, 32, 0x13AF, EffectLayer.Waist );
				from.PlaySound( 0x1FE );
			}
		}
		
		public void Summon()
		{
			Map map = this.Map;

			if ( map == null )
				return;

			int newSummon = Utility.RandomMinMax( 3, 6 );

			for ( int i = 0; i < newSummon; ++i )
			{
				SumGazerLarva summon = new SumGazerLarva();

				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 3 ) - 1;
					int y = Y + Utility.Random( 3 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}
				
				summon.Team = this.Team;
				summon.MoveToWorld( loc, map );
				summon.Combatant = null;
			}
		}
		
		public Beholder( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
