using System;
using Server;
using Server.Items;
using Server.Spells;
using Server.Spells.Seventh;
using Server.Spells.Fifth;

namespace Server.Mobiles
{
	public class BlackLich : BaseCreature
	{
		[Constructable]
		public BlackLich() : base( AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			SpeechHue = Utility.RandomDyedHue();
			Hue = 0x2C3;
			Female = false;
			BodyValue = 24;
			BaseSoundID = 1001;
			Name = "a black lich";

			SetStr( 216, 305 );
			SetDex( 46, 115 );
			SetInt( 166, 305 );

			SetHits( 2000 );
			SetMana( 2000 );

			SetDamage( 10, 25 );

			SetDamageType( ResistanceType.Physical, 70 );
			SetDamageType( ResistanceType.Cold, 15 );
			SetDamageType( ResistanceType.Energy, 15 );

			SetResistance( ResistanceType.Physical, 40, 50 );
			SetResistance( ResistanceType.Fire, 30, 40 );
			SetResistance( ResistanceType.Cold, 50, 60 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 40, 50 );

			SetSkill( SkillName.EvalInt, 77.6, 87.5 );
			SetSkill( SkillName.Necromancy, 120.6, 150.5 );
			SetSkill( SkillName.SpiritSpeak, 120.1, 150.5 );
			SetSkill( SkillName.Magery, 90.1, 150.1);
			SetSkill( SkillName.Poisoning, 80.5 );
			SetSkill( SkillName.Meditation, 110.0 );
			SetSkill( SkillName.MagicResist, 80.1, 85.0 );
			SetSkill( SkillName.Parry, 90.1, 95.1 );
			SetSkill( SkillName.Tactics, 100.0 );
			SetSkill( SkillName.Wrestling, 70.1, 80.0 );

			Fame = 19000;
			Karma = -15000;

			VirtualArmor = 65;

			PackNecroReg( 50, 100 );
			if (Utility.RandomDouble() < 0.2)
				PackItem( new LichStaff() );
			if (Utility.RandomDouble() < 0.2)
				PackItem( new RandomTalisman() );

			AddItem( new NecromancerSpellbook( (UInt64)0xFFFF ) );
			PackItem( Loot.RandomNewPotion() );	
			PackItem( Loot.RandomScroll( 1, 4, SpellbookType.Necromancer ) );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich, 2 );
			AddLoot( LootPack.Rich, 2 );
         AddLoot( LootPack.HighScrolls, 4 );
		}

		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override int TreasureMapLevel{ get{ return 5; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public void Polymorph( Mobile m )
		{
			if ( !m.CanBeginAction( typeof( PolymorphSpell ) ) || !m.CanBeginAction( typeof( IncognitoSpell ) ) || m.IsBodyMod || !m.Player )
				return;

			IMount mount = m.Mount;

			if ( mount != null )
				mount.Rider = null;

			if ( m.Mounted )
				return;

			if ( m.BeginAction( typeof( PolymorphSpell ) ) )
			{
				// 				Item disarm = m.FindItemOnLayer( Layer.OneHanded );
				// 
				// 				if ( disarm != null && disarm.Movable )
				// 					m.AddToBackpack( disarm );
				// 
				// 				disarm = m.FindItemOnLayer( Layer.TwoHanded );
				// 
				// 				if ( disarm != null && disarm.Movable )
				// 					m.AddToBackpack( disarm );

				m.BodyMod = 50;
				m.HueMod = 0;

				new ExpirePolymorphTimer( m ).Start();
			}
		}

		private class ExpirePolymorphTimer : Timer
		{
			private Mobile m_Owner;

			public ExpirePolymorphTimer( Mobile owner ) : base( TimeSpan.FromMinutes( 2.0 ) )
			{
				m_Owner = owner;

				Priority = TimerPriority.OneSecond;
			}

			protected override void OnTick()
			{
				if ( !m_Owner.CanBeginAction( typeof( PolymorphSpell ) ) )
				{
					m_Owner.BodyMod = 0;
					m_Owner.HueMod = -1;
					m_Owner.EndAction( typeof( PolymorphSpell ) );
				}
			}
		}

		public void SpawnWraiths( Mobile target )
		{
			Map map = this.Map;

			if ( map == null )
				return;

			int newWraiths = Utility.RandomMinMax( 2, 5 );

			for ( int i = 0; i < newWraiths; ++i )
			{
				BlackLichWraith wraith = new BlackLichWraith();

				wraith.Team = this.Team;
				wraith.FightMode = FightMode.Closest;
				// 				wraith.Summoned = true;
				// 			   wraith.SummonMaster = this;


				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 3 ) - 1;
					int y = Y + Utility.Random( 3 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}

				wraith.MoveToWorld( loc, map );
				wraith.Combatant = null;
			}
		}

		public void DoSpecialAbility( Mobile target )
		{
			if ( 0.1 >= Utility.RandomDouble() )
				Polymorph( target );

			if ( 0.08 >= Utility.RandomDouble() )
				SpawnWraiths( target );
		}

		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );

			DoSpecialAbility( defender );

			// 			defender.Damage( Utility.Random( 20, 10 ), this );
			defender.Stam -= Utility.Random( 5, 10 );
			defender.Mana -= Utility.Random( 5, 10 );
		}

		public override void OnGotMeleeAttack( Mobile attacker )
		{
			base.OnGotMeleeAttack( attacker );

			DoSpecialAbility( attacker );

		}

		public BlackLich( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
