using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "a daemonic roach corpse" )]
	public class DaemonicRoach : BaseCreature
	{
		private Timer m_Timer;
		
		[Constructable]
		public DaemonicRoach() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a daemonic roach";
			Body = 787;
			BaseSoundID = 1006;
			Hue = 987;

			SetStr( 296, 320 );
			SetDex( 81, 105 );
			SetInt( 36, 60 );

			SetHits( 651, 762 );

			SetDamage( 10, 21 );

			SetDamageType( ResistanceType.Physical, 30 );
			SetDamageType( ResistanceType.Poison, 70 );

			SetResistance( ResistanceType.Physical, 45, 60 );
			SetResistance( ResistanceType.Fire, 25, 35 );
			SetResistance( ResistanceType.Cold, 30, 40 );
			SetResistance( ResistanceType.Poison, 40, 70 );
			SetResistance( ResistanceType.Energy, 30, 35 );

			SetSkill( SkillName.MagicResist, 70.0 );
			SetSkill( SkillName.Tactics, 110.0 );
			SetSkill( SkillName.Wrestling, 110.0 );
			SetSkill( SkillName.Anatomy, 50.1, 90.0 );
			
			Fame = 24000;
			Karma = -4500;

			VirtualArmor = 45;

			PackItem( new Tokens( Utility.RandomMinMax( 5, 15 ) ) );
			PackItem( Loot.RandomNewPotion() );

			if ( 0.05 > Utility.RandomDouble() )
			{
				switch ( Utility.Random( 5 ) )
				{
					default:
					case 0: PackItem( new BardBones() ) ; break;
					case 1: PackItem( new RogueBones() ) ; break;
					case 2: PackItem( new MageBones() ) ; break;
					case 3: PackItem( new WarriorBones() ) ; break;
					case 4: PackItem( new HealerBones() ) ; break;
				}
			}

			m_Timer = new InternalTimer( this );
			m_Timer.Start();
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich, 3 );
			AddLoot( LootPack.Rich, 2 );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.05, typeof( RunicDa ) );
		}

		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override Poison HitPoison{ get{ return Utility.RandomBool() ? Poison.Deadly : Poison.Greater; } }
		public override double HitPoisonChance{ get{ return 0.5; } }
		public override int TreasureMapLevel{ get{ return 5; } }
		public override int Meat{ get{ return 5; } }
		public override int Hides{ get{ return 10; } }
		public override HideType HideType{ get{ return HideType.Daemon; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }

		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			if ( 0.6 > Utility.RandomDouble() && from != null && from != this && this.CanSee( from ) )
			{
				SpillAcid( TimeSpan.FromSeconds( 10 ), 10, 40, from );
			}
			base.OnDamage( amount, from, willKill, typ );
		}
		
		public override bool OnBeforeDeath()
		{
			SpillAcid( TimeSpan.FromSeconds( 10 ), 20, 40, 2, 5 );
			m_Timer.Stop();
			return base.OnBeforeDeath();
		}
		
		private class InternalTimer : Timer
		{
			private DaemonicRoach m_Owner;
			private int m_Count = 0;

			public InternalTimer( DaemonicRoach owner ) : base( TimeSpan.FromSeconds( 0.1 ), TimeSpan.FromSeconds( 0.1 ) )
			{
				m_Owner = owner;
				Priority = TimerPriority.TenMS;
			}

			protected override void OnTick()
			{
				if ( (m_Count++ & 0x3) == 0 )
				{
					m_Owner.Direction = (Direction)(Utility.Random( 8 ) | 0x80);
				}

				m_Owner.Move( m_Owner.Direction );
			}
		}
		
		public override int GetAngerSound()
		{
			return 0x5A;
		}

		public override int GetIdleSound()
		{
			return 0x5A;
		}

		public override int GetAttackSound()
		{
			return 0x164;
		}

		public override int GetHurtSound()
		{
			return 0x187;
		}

		public override int GetDeathSound()
		{
			return 0x1BA;
		}

		public override void OnDelete()
		{
			m_Timer.Stop();
			base.OnDelete();
		}
		
		public DaemonicRoach( Serial serial ) : base( serial )
		{
			m_Timer = new InternalTimer( this );
			m_Timer.Start();
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
