/*
*   Scripter : 
*   Author : Lord Mashadow // Avalon Team
*   Generator : Avalon Script Creator
*   Created at :  1.9.2007 13:37:22
*   Thank you for using this tool, feel free to visit our web site  www.avalon.gen.tr
*/
using System;
using Server;
using Server.Items;
using Server.Mobiles;

namespace Server.Mobiles
{
    //[CorpseName( "Deepwater Slime corpse" )]
    public class DeepwaterSlime : BaseCreature
    {
        int slimehue = Utility.RandomMinMax( 1555, 1600 );
        
        [Constructable]
        public DeepwaterSlime() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
        {
            this.Name = "Deepwater Slime";
            this.Hue = slimehue;
            this.Body = 319;// 95 bugged
            this.BaseSoundID = 843;

            this.SetStr( 1000, 1220 );
            this.SetDex( 40, 60 );
            this.SetInt( 50, 60 );
            this.SetHits( 700, 850 );
			   this.SetDamage( 15, 33 );
            
            this.SetDamageType( ResistanceType.Cold, 100 );
            
            this.SetResistance( ResistanceType.Physical, 40 );
            this.SetResistance( ResistanceType.Cold, 70 );
            this.SetResistance( ResistanceType.Fire, 25 );
            this.SetResistance( ResistanceType.Energy, 35 );
            this.SetResistance( ResistanceType.Poison, 72 );
            
            this.Fame = 16000;
            this.Karma = -5000;
            this.VirtualArmor = 30;
            
			   this.CanSwim = true;
			   this.CantWalk = true;
			   
            AddItem( new LightSource() );
            
				PackItem( new MessageInABottle() );				
			   PackItem( new SpecialFishingNet() ); //Confirm?
				PackItem( new WhitePearl( 5 ) );
				PackItem( new FishBones() );
				PackItem( new FishBones() );
				PackItem( new FishBones() );				
			   if( Utility.RandomDouble() < 0.75 )
				  PackItem( new PortSextant() );
			   if( Utility.RandomDouble() < 0.1 )
				  PackItem( new WaterRing() );
			   if( Utility.RandomDouble() < 0.3 )
				  PackItem( new SailorBones() );
        }

      public override Poison HitPoison{ get{ return Poison.Greater; } }
		public override double HitPoisonChance{ get{ return 0.2; } }
      public override FoodType FavoriteFood{ get{ return FoodType.Fish; } }
		public override bool HasBreath{ get{ return true; } }
		public override int BreathPhysicalDamage{ get{ return 30; } } // TODO: Verify damage type
		public override int BreathColdDamage{ get{ return 70; } }
		public override int BreathFireDamage{ get{ return 0; } }
		public override int BreathEffectHue{ get{ return slimehue; } }
		public override double BreathDamageScalar{ get{ return 0.05; } }
		public override double BreathMinDelay{ get{ return 5.0; } }
		public override double BreathMaxDelay{ get{ return 7.5; } }
		public override bool BleedImmune{ get{ return true; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich, 3 );
		}


		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.ParalyzingBlow : WeaponAbility.CrushingBlow;
		}

        public DeepwaterSlime( Serial serial ) : base( serial )
        {
        }

        public override void Serialize( GenericWriter writer )
        {
            base.Serialize( writer );
            writer.Write( (int) 0 );
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize( reader );
            int version = reader.ReadInt();
        }
    }
}