using System;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Spells;
using Server.Engines.CannedEvil;

namespace Server.Mobiles
{
	public class ElderOni : BaseChampion
	{
		public override bool ClickTitle { get { return false; } }
		public override bool ShowFameTitle { get { return false; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override Poison HitPoison { get { return Poison.Greater; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.ConcussionBlow : WeaponAbility.CrushingBlow;
		}

		private DateTime m_Delay = DateTime.Now;
		private int m_Scavengers = 0;

		private static Type[] m_LesserArtifacts = new Type[]
		{
			typeof(MagicalWire), typeof(SlzaAuberonu), typeof(MesicniKamen), typeof(ArtifactFragment),
            typeof(AncientFarmersKasa), typeof(AncientSamuraiDo), typeof(ArmsOfTacticalExcellence), typeof(BlackLotusHood),
				typeof(DaimyosHelm), typeof(DemonForks), typeof(DragonNunchaku), typeof(Exiler), typeof(GlovesOfTheSun), typeof(SwordOfTheStampede),
				typeof(HanzosBow), typeof(LegsOfStability), typeof(PeasantsBokuto), typeof(PilferedDancerFans), typeof(TheDestroyer),
				typeof(TomeOfEnlightenment), typeof(AncientUrn), typeof(HonorableSwords), typeof(PigmentsOfTokuno), typeof(FluteOfRenewal)
		};

		public override ChampionSkullType SkullType { get { return ChampionSkullType.Greed; } }

		[Constructable]
		public ElderOni() : this (false, 3)
		{
		}

		[Constructable]
		public ElderOni(int range) : this (false, range)
		{
		}

		[Constructable]
		public ElderOni(bool ischampion, int range) : base(AIType.AI_Necromage, FightMode.Closest, ischampion, range)
		{
			Hue = 1097;
			Name = "an elder oni";
			Body = 241;

			DropMin = 30;
			DropMax = 70;
			DropType = ChampDrop.DemonDust;
			BonusLoot = "mesicnikamen";
			BonusLootAmount = 1;

			SetStr(700, 720);
			SetDex(1000, 1100);
			SetStr(700, 720);

			SetHits(99000);
			SetMana(2500);
			SetStam(1000);

			SetDamage(25, 29);

			SetDamageType(ResistanceType.Cold, 70);
			SetDamageType(ResistanceType.Poison, 30);

			SetResistance(ResistanceType.Physical, 65, 75);
			SetResistance(ResistanceType.Fire, 65, 75);
			SetResistance(ResistanceType.Cold, 65, 75);
			SetResistance(ResistanceType.Poison, 65, 75);
			SetResistance(ResistanceType.Energy, 65, 75);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Necromancy, 190.6, 220.5);
			SetSkill(SkillName.SpiritSpeak, 90.1, 120.5);
			SetSkill(SkillName.Magery, 150.1, 160.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 100.1);
			SetSkill(SkillName.Tactics, 120.0);
			SetSkill(SkillName.Anatomy, 100.0);
			SetSkill(SkillName.Wrestling, 90.1, 120.0);
			SetSkill(SkillName.Swords, 115.1, 120.0);

			Fame = 10000;
			Karma = -15000;

			Item reags = Loot.RandomReagent();
			reags.Amount = 30;
			PackItem(reags);
			PackItem((Item)Activator.CreateInstance(m_LesserArtifacts[Utility.Random(m_LesserArtifacts.Length)]));
			PackItem(Engines.Plants.Seed.RandomBonsaiSeed());

			if (Utility.RandomDouble() < 0.75)
				PackItem(new ScrollOfKo());
		}

		public override bool OnBeforeDeath()
		{
			if (!base.OnBeforeDeath())
				return false;

			Server.Regions.KhaldunRegion.DropHealthOrb(this);

			Effects.SendLocationEffect(Location, Map, 0x376A, 10, 1);
			return true;
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if (m_Scavengers < 30 && Utility.RandomDouble() < 0.025 && this.Hits < (this.HitsMax * 90) / 100)
			{
				Oni scavenger = new Oni();

				scavenger.IsTeragon = true;

				scavenger.Fame = 8000;
				scavenger.MoveToWorld(TavaraSewel.GetSpawnPosition(from.Location, from.Map, 7), from.Map);
				scavenger.Combatant = from;
				m_Scavengers++;
			}

			if (Utility.RandomDouble() < 0.007 && from.Player)
			{
				KhalAnkur.Waller(3, 8, from);
			}

			if (Utility.RandomDouble() < 0.005 && this.Hits < (this.HitsMax * 80) / 100 && from.Player)
			{
				LysanderGathenwale.SummoningRing(this, typeof(RevenantLion));
			}

			if (Utility.RandomDouble() < 0.015 && this.Hits < (this.HitsMax * 50) / 100)
			{
				Server.Engines.XmlSpawner2.FlareVortex vortex = new Server.Engines.XmlSpawner2.FlareVortex();

				vortex.ItemID = 9417;
				vortex.Hue = 0;
				vortex.Name = null;
				vortex.MoveToWorld(TavaraSewel.GetSpawnPosition(from.Location, from.Map, 10), from.Map);
			}

			if(Utility.RandomDouble() < 0.002)
			{
				if(!KhalAnkur.IsUnderInfluence(from))
				{
					KhalAnkur.Silence(from, this);
				}
			}

			if (DateTime.Now > m_Delay && this.Hits < (this.HitsMax * 70) / 100)
			{
				m_Delay = DateTime.Now + TimeSpan.FromSeconds(Utility.RandomMinMax(30, 60));

				Effects.PlaySound(this.Location, this.Map, this.GetAngerSound());
				LysanderGathenwale.SummoningRing(this, typeof(KazeKemono));
				Server.Regions.KhaldunRegion.DropHealthOrb(this);

				ArrayList targets = Utilitky.GetTargets(this, 8, true);

				for (int i = 0; i < targets.Count; ++i)
				{
					Mobile m = (Mobile)targets[i];

					if (m == null || m.Deleted)
						continue;

					m.RevealingAction();
					m.PlaySound(0x50D);
					m.FixedParticles(0x37B9, 1, 5, 0x251D, 0x651, 0, EffectLayer.Waist);

					int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(Utility.RandomMinMax(25, 50), m);

					if (m is Xanthos.Interfaces.IEvoCreature)
						auradamage *= 5;

					m.Hits -= auradamage;
					m.Mana /= 2;
					ISTile5.SendDmgPacket(m, auradamage);

					if (m.Hits < 2)
						m.Kill();
				}
			}
		}

		public override int GetAngerSound()
		{
			return 0x4E3;
		}

		public override int GetIdleSound()
		{
			return 0x4E2;
		}

		public override int GetAttackSound()
		{
			return 0x4E1;
		}

		public override int GetHurtSound()
		{
			return 0x4E4;
		}

		public override int GetDeathSound()
		{
			return 0x4E0;
		}

		public ElderOni(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}