using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "an elder fire elemental corpse" )]
	public class ElderFireElemental : BaseCreature
	{
		private DateTime m_Delay = DateTime.Now;
		
      [Constructable]
		public ElderFireElemental () : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "an elder fire elemental";
			Body = 752;
			BaseSoundID = 268;
			Hue = 1161;

			SetStr( 226, 355 );
			SetDex( 40, 70 );
			SetInt( 501, 625 );

			SetHits( 760, 930 );

			SetDamage( 15, 25 );

			SetDamageType( ResistanceType.Physical, 15 );
			SetDamageType( ResistanceType.Fire, 85 );

			SetResistance( ResistanceType.Physical, 55, 75 );
			SetResistance( ResistanceType.Fire, 100 );
			SetResistance( ResistanceType.Cold, 25, 30 );
			SetResistance( ResistanceType.Poison, 55, 75 );
			SetResistance( ResistanceType.Energy, 55, 75 );

			SetSkill( SkillName.EvalInt, 160.1, 215.0 );
			SetSkill( SkillName.Magery, 160.1, 175.0 );
			SetSkill( SkillName.MagicResist, 75.2, 105.0 );
			SetSkill( SkillName.Tactics, 90.1, 110.0 );
			SetSkill( SkillName.Wrestling, 100.1, 110.0 );

			Fame = 20000;
			Karma = -4500;

			VirtualArmor = 50;

			PackItem( new SulfurousAsh( 30 ) );

			AddItem( new LightSource() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich, 2 );
			AddLoot( LootPack.Gems, 6 );
		}

		public override bool BleedImmune{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override void OnThink()
		{
			if ( DateTime.Now > m_Delay )
			{
				Ability.Aura( this, 20, 40, 1, 6, 0, "The hot air scorches your skin", true );
				m_Delay = DateTime.Now + TimeSpan.FromSeconds( 3 );
			}
			base.OnThink();
		}
		
		public ElderFireElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			if ( BaseSoundID == 274 )
				BaseSoundID = 838;
		}
	}
}
