using System;
using System.Collections;
using Server.Items;
using Server.Targeting;

namespace Server.Mobiles
{
	//[CorpseName( "a giant earth elemental corpse" )]
	public class GiantEarthElemental : BaseCreature
	{
      public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.ParalyzingBlow : WeaponAbility.CrushingBlow;
		}
		
		private DateTime m_Delay = DateTime.Now;
		
		[Constructable]
		public GiantEarthElemental() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a giant earth elemental";
			Body = 752;
			BaseSoundID = 268;
			Hue = 46;

			SetStr( 100, 300 );
			SetDex( 10, 20 );
			SetInt( 20, 30 );

			SetHits( 1200, 1400 );

			SetDamage( 15, 30 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 100 );
			SetResistance( ResistanceType.Fire, 40, 70 );
			SetResistance( ResistanceType.Cold, 40, 70 );
			SetResistance( ResistanceType.Poison, 60, 70 );
			SetResistance( ResistanceType.Energy, 40, 70 );

			SetSkill( SkillName.MagicResist, 50.1, 95.0 );
			SetSkill( SkillName.Tactics, 60.1, 100.0 );
			SetSkill( SkillName.Wrestling, 60.1, 100.0 );

			Fame = 20000;
			Karma = -3500;

			VirtualArmor = 64;
			Tamable = false;

			PackItem( new FertileDirt( Utility.RandomMinMax( 5, 10 ) ) );
			PackItem( new IronOre( 30 ) ); // TODO: Five small iron ore
			PackItem( new MandrakeRoot( Utility.RandomMinMax( 15, 20 ) ) );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Average );
			AddLoot( LootPack.UltraRich );
			AddLoot( LootPack.Gems, 4 );			
		}

		public override void OnThink()
		{
			if ( DateTime.Now > m_Delay )
			{
				Ability.Aura( this, 80, 100, 0, 10, 0, "Elemental uderil pesti do zeme az se vsechno kolem otraslo." );
				m_Delay = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 20, 30 ) );
				this.Animate( 5, 5, 1, true, false, 0 );
			}

			base.OnThink();
		}

		public override bool BleedImmune{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public GiantEarthElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}