using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "an ore elemental corpse" )]
	public class SilverElemental : BaseCreature
	{
	
		[Constructable]
		public SilverElemental() : this( 5 )
		{
		}
		
		[Constructable]
		public SilverElemental( int oreAmount ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a silver elemental";
			Body = 107;
			BaseSoundID = 268;
			Hue = 1182;

			SetStr( 180, 200 );
			SetDex( 180, 200 );
			SetInt( 130, 140 );

			SetHits( 300, 450 );

			SetDamage( 10, 13 );

			SetDamageType( ResistanceType.Physical, 30 );
			SetDamageType( ResistanceType.Cold, 70 );
			
			SetResistance( ResistanceType.Physical, 30, 40 );
			SetResistance( ResistanceType.Fire, 40, 50 );
			SetResistance( ResistanceType.Cold, 70 );
			SetResistance( ResistanceType.Poison, 30, 40 );
			SetResistance( ResistanceType.Energy, 10, 20 );

			SetSkill( SkillName.MagicResist, 50.1, 95.0 );
			SetSkill( SkillName.Tactics, 60.1, 100.0 );
			SetSkill( SkillName.Wrestling, 60.1, 100.0 );

			Fame = 5500;
			Karma = -3500;

			VirtualArmor = 32;

			PackItem( new SilverOre( oreAmount ) );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.03, typeof( RunicSil ) );
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems, 4 );
		}
		
		public override bool AutoDispel{ get{ return true; } }
		public override bool BleedImmune{ get{ return true; } }
		
		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
    		if ( from != null )
         {
            int hitback = damage / 4;
    			AOS.Damage( from, this, hitback, 30, 70, 0, 0, 0 );
         }
		}

		public SilverElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
    
    //[CorpseName( "an ore elemental corpse" )]
	public class PlatinumElemental : BaseCreature
	{
	
		[Constructable]
		public PlatinumElemental() : this( 5 )
		{
		}
		
		[Constructable]
		public PlatinumElemental( int oreAmount ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a platinum elemental";
			Body = 107;
			BaseSoundID = 268;
			Hue = 0x494;

			SetStr( 190, 210 );
			SetDex( 50, 60 );
			SetInt( 140, 150 );

			SetHits( 400, 610 );

			SetDamage( 10, 16 );

			SetDamageType( ResistanceType.Physical, 30 );
			SetDamageType( ResistanceType.Fire, 70 );
			
			SetResistance( ResistanceType.Physical, 30, 40 );
			SetResistance( ResistanceType.Fire, 70 );
			SetResistance( ResistanceType.Cold, 40, 50 );
			SetResistance( ResistanceType.Poison, 30, 40 );
			SetResistance( ResistanceType.Energy, 10, 20 );

			SetSkill( SkillName.MagicResist, 50.1, 95.0 );
			SetSkill( SkillName.Tactics, 60.1, 100.0 );
			SetSkill( SkillName.Wrestling, 60.1, 100.0 );

			Fame = 5500;
			Karma = -3500;

			VirtualArmor = 32;

			PackItem( new PlatinumOre( oreAmount ) );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.03, typeof( RunicP ) );
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems, 4 );
		}

		public override bool AutoDispel{ get{ return true; } }
		public override bool BleedImmune{ get{ return true; } }

		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
    		if ( from != null )
         {
            int hitback = damage / 4;
    			AOS.Damage( from, this, hitback, 30, 0, 70, 0, 0 );
         }
		}

		public PlatinumElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
    
    //[CorpseName( "an ore elemental corpse" )]
	public class MythrilElemental : BaseCreature
	{
	
		[Constructable]
		public MythrilElemental() : this( 5 )
		{
		}
		
		[Constructable]
		public MythrilElemental( int oreAmount ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a mythril elemental";
			Body = 107;
			BaseSoundID = 268;
			Hue = 0x486;

			SetStr( 190, 210 );
			SetDex( 50, 60 );
			SetInt( 140, 150 );

			SetHits( 400, 610 );

			SetDamage( 12, 16 );

			SetDamageType( ResistanceType.Physical, 30 );
			SetDamageType( ResistanceType.Poison, 70 );
			
			SetResistance( ResistanceType.Physical, 30, 40 );
			SetResistance( ResistanceType.Fire, 40, 50 );
			SetResistance( ResistanceType.Cold, 40, 50 );
			SetResistance( ResistanceType.Poison, 70 );
			SetResistance( ResistanceType.Energy, 10, 20 );

			SetSkill( SkillName.MagicResist, 50.1, 95.0 );
			SetSkill( SkillName.Tactics, 60.1, 100.0 );
			SetSkill( SkillName.Wrestling, 60.1, 100.0 );

			Fame = 5500;
			Karma = -3500;

			VirtualArmor = 32;

			PackItem( new MythrilOre( oreAmount ) );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.03, typeof( RunicM ) );
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems, 4 );
		}

		public override bool AutoDispel{ get{ return true; } }
		public override bool BleedImmune{ get{ return true; } }

		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
    		if ( from != null )
         {
            int hitback = damage / 4;
    			AOS.Damage( from, this, hitback, 30, 0, 0, 70, 0 );
         }
		}

		public MythrilElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
    
    	//[CorpseName( "an ore elemental corpse" )]
	public class ObsidianElemental : BaseCreature
	{
	
		[Constructable]
		public ObsidianElemental() : this( 5 )
		{
		}
		
		[Constructable]
		public ObsidianElemental( int oreAmount ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "an obsidian elemental";
			Body = 107;
			BaseSoundID = 268;
			Hue = 0x455;

			SetStr( 190, 210 );
			SetDex( 50, 60 );
			SetInt( 140, 150 );

			SetHits( 400, 610 );

			SetDamage( 12, 16 );

			SetDamageType( ResistanceType.Physical, 30 );
			SetDamageType( ResistanceType.Energy, 70 );
			
			SetResistance( ResistanceType.Physical, 30, 40 );
			SetResistance( ResistanceType.Fire, 40, 50 );
			SetResistance( ResistanceType.Cold, 40, 50 );
			SetResistance( ResistanceType.Poison, 30, 40 );
			SetResistance( ResistanceType.Energy, 70 );

			SetSkill( SkillName.MagicResist, 50.1, 95.0 );
			SetSkill( SkillName.Tactics, 60.1, 100.0 );
			SetSkill( SkillName.Wrestling, 60.1, 100.0 );

			Fame = 5500;
			Karma = -3500;

			VirtualArmor = 32;

			PackItem( new ObsidianOre( oreAmount ) );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.03, typeof( RunicO ) );
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems, 4 );
		}

		public override bool AutoDispel{ get{ return true; } }
		public override bool BleedImmune{ get{ return true; } }

		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
    		if ( from != null )
         {
            int hitback = damage / 4;
    			AOS.Damage( from, this, hitback, 30, 0, 0, 0, 70 );
         }
		}

		public ObsidianElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
    
    	//[CorpseName( "an ore elemental corpse" )]
	public class JadeElemental : BaseCreature
	{
		private DateTime m_Delay = DateTime.Now;
		
		[Constructable]
		public JadeElemental() : this( 5 )
		{
		}
		
		[Constructable]
		public JadeElemental( int oreAmount ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a jade elemental";
			Body = 107;
			BaseSoundID = 268;
			Hue = 0x48C;

			SetStr( 190, 210 );
			SetDex( 50, 60 );
			SetInt( 140, 150 );

			SetHits( 400, 600 );

			SetDamage( 12, 16 );

			SetDamageType( ResistanceType.Poison, 100 );
			
			SetResistance( ResistanceType.Physical, 30, 70 );
			SetResistance( ResistanceType.Fire, 40, 70 );
			SetResistance( ResistanceType.Cold, 40, 70 );
			SetResistance( ResistanceType.Poison, 100 );
			SetResistance( ResistanceType.Energy, 40, 70 );

			SetSkill( SkillName.MagicResist, 50.1, 95.0 );
			SetSkill( SkillName.Tactics, 60.1, 100.0 );
			SetSkill( SkillName.Wrestling, 60.1, 100.0 );

			Fame = 9500;
			Karma = -3500;

			VirtualArmor = 32;

			PackItem( new JadeOre( oreAmount ) );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.03, typeof( RunicJ ) );
		}
		
		public override void OnActionCombat()
		{
			if ( DateTime.Now > m_Delay )
			{
				Ability.Aura( this, 0, 0, 3, 3, 4, "It exhails a cloud of noxious vapors" );
				m_Delay = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 5, 10 ) );
			}
			base.OnActionCombat();
		}
		
		public override bool AutoDispel{ get{ return true; } }
		public override bool BleedImmune{ get{ return true; } }

		public override void AlterMeleeDamageTo( Mobile to, ref int damage )
		{
			if ( 0.2 >= Utility.RandomDouble() )
			{
				Ability.DamageArmor( to, 1, 5 );
			}
		}

		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
			Item item = from.FindItemOnLayer( Layer.OneHanded );

			if ( item == null )
				item = from.FindItemOnLayer( Layer.TwoHanded );

         if ( item is BaseWeapon && !( item is LegendaryPickaxe ) )
         {
            BaseWeapon weapon = (BaseWeapon)item;
            
            if ( from != null && weapon.Resource == CraftResource.Iron )
            {
               damage = 0; //jde  zranit jen barevnymy kovy
               from.SendMessage( 89, "Elemental je imunni proti zbranim ze bezneho kovu." );
            }
         }         
         else
    		{
    			if ( from != null )
            {
               int hitback = damage / 2;
    			   AOS.Damage( from, this, hitback, 0, 0, 0, 100, 0 );
            }
    		}

			if ( from is BaseCreature )
			{
				BaseCreature bc = (BaseCreature)from;

				if ( bc.Controlled || bc.BardTarget == this )
					damage = 0; // Immune to pets and provoked creatures
			}
		}

		public override void CheckReflect( Mobile caster, ref bool reflect )
		{
			reflect = true; // Every spell is reflected back to the caster
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems, 4 );
		}
		
		public JadeElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
    
    	//[CorpseName( "an ore elemental corpse" )]
	public class MoonstoneElemental : BaseCreature
	{
	
		[Constructable]
		public MoonstoneElemental() : this( 5 )
		{
		}
		
		[Constructable]
		public MoonstoneElemental( int oreAmount ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a moonstone elemental";
			Body = 107;
			BaseSoundID = 268;
			Hue = 0x484;

			SetStr( 190, 210 );
			SetDex( 50, 60 );
			SetInt( 140, 150 );

			SetHits( 400, 600 );

			SetDamage( 12, 16 );

			SetDamageType( ResistanceType.Cold, 100 );
			
			SetResistance( ResistanceType.Physical, 30, 70 );
			SetResistance( ResistanceType.Fire, 40, 70 );
			SetResistance( ResistanceType.Cold, 100 );
			SetResistance( ResistanceType.Poison, 30, 70 );
			SetResistance( ResistanceType.Energy, 40, 70 );

			SetSkill( SkillName.MagicResist, 50.1, 95.0 );
			SetSkill( SkillName.Tactics, 60.1, 100.0 );
			SetSkill( SkillName.Wrestling, 60.1, 100.0 );

			Fame = 9500;
			Karma = -3500;

			VirtualArmor = 32;

			PackItem( new MoonstoneOre( oreAmount ) );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.03, typeof( RunicMo ) );
		}

		public override bool AutoDispel{ get{ return true; } }
		public override bool BleedImmune{ get{ return true; } }

		public override void AlterMeleeDamageTo( Mobile to, ref int damage )
		{
			if ( 0.2 >= Utility.RandomDouble() )
			{
				Ability.DamageArmor( to, 1, 5 );
			}
		}

		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
			Item item = from.FindItemOnLayer( Layer.OneHanded );

			if ( item == null )
				item = from.FindItemOnLayer( Layer.TwoHanded );

         if ( item is BaseWeapon && !( item is LegendaryPickaxe ) )
         {
            BaseWeapon weapon = (BaseWeapon)item;
            
            if ( from != null && weapon.Resource == CraftResource.Iron )
            {
               damage = 0; //jde  zranit jen barevnymy kovy
               from.SendMessage( 89, "Elemental je imunni proti zbranim ze bezneho kovu." );
            }
         }         
         else
    		{
    			if ( from != null )
            {
               int hitback = damage / 2;
    			   AOS.Damage( from, this, hitback, 0, 0, 100, 0, 0 );
            }
    		}

			if ( from is BaseCreature )
			{
				BaseCreature bc = (BaseCreature)from;

				if ( bc.Controlled || bc.BardTarget == this )
					damage = 0; // Immune to pets and provoked creatures
			}
		}

		public override void CheckReflect( Mobile caster, ref bool reflect )
		{
			reflect = true; // Every spell is reflected back to the caster
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems, 4 );
		}
		
		public MoonstoneElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
    
    	//[CorpseName( "an ore elemental corpse" )]
	public class SunstoneElemental : BaseCreature
	{
	
		[Constructable]
		public SunstoneElemental() : this( 5 )
		{
		}
		
		[Constructable]
		public SunstoneElemental( int oreAmount ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a sunstone elemental";
			Body = 107;
			BaseSoundID = 268;
			Hue = 0x550;

			SetStr( 190, 210 );
			SetDex( 50, 60 );
			SetInt( 140, 150 );

			SetHits( 400, 600 );

			SetDamage( 12, 16 );

			SetDamageType( ResistanceType.Fire, 100 );
			
			SetResistance( ResistanceType.Physical, 30, 70 );
			SetResistance( ResistanceType.Fire, 100 );
			SetResistance( ResistanceType.Cold, 40, 70 );
			SetResistance( ResistanceType.Poison, 30, 70 );
			SetResistance( ResistanceType.Energy, 40, 70 );

			SetSkill( SkillName.MagicResist, 50.1, 95.0 );
			SetSkill( SkillName.Tactics, 60.1, 100.0 );
			SetSkill( SkillName.Wrestling, 60.1, 100.0 );

			Fame = 9500;
			Karma = -3500;

			VirtualArmor = 32;

			PackItem( new SunstoneOre( oreAmount ) );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.03, typeof( RunicSu ) );
		}

		public override bool AutoDispel{ get{ return true; } }
		public override bool BleedImmune{ get{ return true; } }

		public override void AlterMeleeDamageTo( Mobile to, ref int damage )
		{
			if ( 0.2 >= Utility.RandomDouble() )
			{
				Ability.DamageArmor( to, 1, 5 );
			}
		}

		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
			Item item = from.FindItemOnLayer( Layer.OneHanded );

			if ( item == null )
				item = from.FindItemOnLayer( Layer.TwoHanded );

         if ( item is BaseWeapon && !( item is LegendaryPickaxe ) )
         {
            BaseWeapon weapon = (BaseWeapon)item;
            
            if ( from != null && weapon.Resource == CraftResource.Iron )
            {
               damage = 0; //jde  zranit jen barevnymy kovy
               from.SendMessage( 89, "Elemental je imunni proti zbranim ze bezneho kovu." );
            }
         }         
         else
    		{
    			if ( from != null )
            {
               int hitback = damage / 2;
    			   AOS.Damage( from, this, hitback, 0, 100, 0, 0, 0 );
            }
    		}

			if ( from is BaseCreature )
			{
				BaseCreature bc = (BaseCreature)from;

				if ( bc.Controlled || bc.BardTarget == this )
					damage = 0; // Immune to pets and provoked creatures
			}
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems, 4 );
		}
		
		public override void CheckReflect( Mobile caster, ref bool reflect )
		{
			reflect = true; // Every spell is reflected back to the caster
		}

		public SunstoneElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
    
    	//[CorpseName( "an ore elemental corpse" )]
	public class BloodstoneElemental : BaseCreature
	{
	
		[Constructable]
		public BloodstoneElemental() : this( 5 )
		{
		}
		
		[Constructable]
		public BloodstoneElemental( int oreAmount ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a bloodstone elemental";
			Body = 107;
			BaseSoundID = 268;
			Hue = 0x485;

			SetStr( 190, 210 );
			SetDex( 50, 60 );
			SetInt( 140, 150 );

			SetHits( 400, 600 );

			SetDamage( 12, 16 );

			SetDamageType( ResistanceType.Energy, 100 );
			
			SetResistance( ResistanceType.Physical, 30, 70 );
			SetResistance( ResistanceType.Fire, 40, 70 );
			SetResistance( ResistanceType.Cold, 40, 70 );
			SetResistance( ResistanceType.Poison, 30, 70 );
			SetResistance( ResistanceType.Energy, 100 );

			SetSkill( SkillName.MagicResist, 50.1, 95.0 );
			SetSkill( SkillName.Tactics, 60.1, 100.0 );
			SetSkill( SkillName.Wrestling, 60.1, 100.0 );

			Fame = 9500;
			Karma = -3500;

			VirtualArmor = 32;

			PackItem( new BloodstoneOre( oreAmount ) );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );			
			PackRunicTool( c, 0.03, typeof( RunicBl ) );
		}

		public override bool AutoDispel{ get{ return true; } }
		public override bool BleedImmune{ get{ return true; } }

		public override void AlterMeleeDamageTo( Mobile to, ref int damage )
		{
			if ( 0.2 >= Utility.RandomDouble() )
			{
				Ability.DamageArmor( to, 1, 5 );
			}
		}

		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
			Item item = from.FindItemOnLayer( Layer.OneHanded );

			if ( item == null )
				item = from.FindItemOnLayer( Layer.TwoHanded );

         if ( item is BaseWeapon && !( item is LegendaryPickaxe ) )
         {
            BaseWeapon weapon = (BaseWeapon)item;
            
            if ( from != null && weapon.Resource == CraftResource.Iron )
            {
               damage = 0; //jde  zranit jen barevnymy kovy
               from.SendMessage( 89, "Elemental je imunni proti zbranim ze bezneho materialu." );
            }
    			else
            {
               int hitback = damage / 2;
    			   AOS.Damage( from, this, hitback, 0, 0, 0, 0, 100 );
            }
         }         

			if ( from is BaseCreature )
			{
				BaseCreature bc = (BaseCreature)from;

				if ( bc.Controlled || bc.BardTarget == this )
					damage = 0; // Immune to pets and provoked creatures
			}
		}

		public override void CheckReflect( Mobile caster, ref bool reflect )
		{
			reflect = true; // Every spell is reflected back to the caster
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems, 4 );
		}
		
		public BloodstoneElemental( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}