using System;
using System.Collections;
using Server.Items;
using Server.ContextMenus;
using Server.Misc;
using Server.Network;
using Server.Gumps;
using Server.Mobiles;

namespace Server.Mobiles
{
	public class Gambler : BaseCreature
	{
		public override bool ClickTitle{ get{ return false; } }
		public override bool CanTeach{ get{ return false; } }
		public virtual bool IsInvulnerable { get { return true; } }
		public override bool DisallowAllMoves { get { return true; } }
		
		public int m_hotovost;

		[CommandProperty( AccessLevel.GameMaster )]
		public int hotovost
		{
			get{ return m_hotovost; }
			set{ m_hotovost = value; }
		}
		
		[Constructable]
		public Gambler() : base( AIType.AI_Melee, FightMode.Aggressor, 20, 1, 0.2, 0.4 )
		{
			SpeechHue = 322;
			Title = "the Gambler";

			Hue = Utility.RandomSkinHue();
			HairItemID = Utility.RandomList( 0x203B, 0x203C, 0x2049, 0x203D  );
			HairHue = Utility.RandomNondyedHue();

			this.Female = true;
			Body = 0x191;
			Name =  NameList.RandomName( "female" );

			AddItem( new FancyShirt( Utility.RandomNeutralHue() ));
			AddItem( new Kilt( Utility.RandomNeutralHue() ));
			AddItem( new Bandana( Utility.RandomNeutralHue() ));
			AddItem(new Shoes(Utility.RandomNeutralHue()));
			
			SetStr( 25, 50 );
			SetDex( 41, 45 );
			SetInt( 21, 35 );
			SetHits( 188, 208 );
			
			CantWalk = true;

			Blessed = true;

			Fame = 0;
			Karma = -1000;
			VirtualArmor = 66;

			AddItem( new Backpack() );
			hotovost = 10000;
		}

		private static TimeSpan m_NextPlapperDelay = TimeSpan.FromSeconds( 30.0 );
		private DateTime m_NextPlapper;


		public override void OnDoubleClick(Mobile m_Mobile)
		{
			if( !( m_Mobile is PlayerMobile ) )
				return;
			
			if( m_Mobile == null )
				return;
			
			PlayerMobile mobile = (PlayerMobile) m_Mobile;
			
			if ( m_Mobile.InRange( this, 5 ) )
			{
				if ( ! mobile.HasGump( typeof( GambleGump ) ) )
				{
					mobile.SendGump( new GambleGump( mobile, this ));
				}
			}
			else
			   m_Mobile.SendLocalizedMessage( 500295 ); //You are too far away to do that.
		}
		
		

		public void gamble( Mobile from, int tip, int einsatz )
		{
			if( einsatz > 10000)
			{
				Say("Neprijmu sazku vyssi nez 10 tisic zlatych!");
				return;
			}
			else if( m_hotovost < (einsatz * 4))
			{
				Say("Omlouvam se, ale bohuzel uz nemam penize na prijmuti tak vysoke castky!");
				Say("Muzes vsadit maximalne {0} zlatych!", m_hotovost / 4 );
				return;
			}
			
			if(tip < 1 || tip > 6)
			{
				Say("A dice has six sides, my friend. Not more, not less.");
				return;
			}
			
			if ( einsatz > 0 )
			{
				Container pack = from.Backpack;
				
				if ( pack != null && pack.ConsumeTotal( typeof( Gold ), einsatz ) )
				{
					string gegeben = "Prohravas " + einsatz + " zlatych";
					from.SendMessage(gegeben);

					int gewinn = 0;
					int wuerfel1 = Utility.Random( 6 ) + 1;
					int wuerfel2 = Utility.Random( 6 ) + 1;

					string gesetzt = "Sazis " + einsatz + " zlatych na cislo " + tip;
					this.Say(gesetzt);
					
					string wurf = "*{0} hazi " + wuerfel1 + " a " + wuerfel2 + "*";
					this.Say(wurf, this.Name);
					
					string ergebnis;
					if(tip == wuerfel1 && tip == wuerfel2)
					{
						gewinn = einsatz * 4;
						ergebnis = "Proklate! Dvojita trefa! Vyhravas " + gewinn + " zlatych!";
					}
					else if(tip == wuerfel1 || tip == wuerfel2)
					{
						gewinn = einsatz * 2;
						ergebnis = "Jedna trefa! Vyhravas " + gewinn + " zlatych!";
					}
					else
					{
						ergebnis = "Tesne vedle. To je mrzute...";
// 						Emote("*potouchly usmev*");
						gewinn = 0;
					}
					Say(ergebnis);
					
					if(gewinn > 0)
					{
						from.AddToBackpack( new Gold(gewinn) );
						m_hotovost =  m_hotovost - gewinn;
					}
					else
					{
						m_hotovost = m_hotovost + einsatz;
					}
					
					m_NextPlapper = DateTime.Now + TimeSpan.FromSeconds( 200 );
				}
				else
				{
					this.Say("Nemas u sebe dost penez!");
				}
			}
			else
			{
				this.Say("That seems to be not enough.");
			}
		}

		public override void OnMovement(Mobile m, Point3D oldLocation)
		{
			if ( m is PlayerMobile /*&& (this.Region.Name == "Norka" || this.Region.Name == "Freienfels" || this.Region.Name == "Persepola")*/ && this.InLOS( m ) && this.CanSee( m ))
				this.Direction =  GetDirectionTo( m.Location );

			if ( m.InRange( this, 5 ) && DateTime.Now >= m_NextPlapper && this.InLOS( m ) && this.CanSee( m ) && m is PlayerMobile && this.Combatant == null)
			{
            this.CurrentSpeed = this.ActiveSpeed;
				
				m_NextPlapper = DateTime.Now + m_NextPlapperDelay;

				switch ( Utility.Random( 3 ))
				{
						case 0: m_NextPlapper = DateTime.Now + m_NextPlapperDelay; this.Say( "Nechces zkusit stesti??" ); break;
						case 1: m_NextPlapper = DateTime.Now + m_NextPlapperDelay; this.Say( "Psst, nechces zkusit vyhrat par zlataku?" ); break;
						case 2: m_NextPlapper = DateTime.Now + m_NextPlapperDelay; this.Say( "Coz takhle zkusit vyhrat ctyrnasobek vsazenych penez?" ); break;
				}
			}
		}


		
		public override bool HandlesOnSpeech( Mobile from )
		{
			if ( from.InRange( this.Location, 5 ) && this.InLOS(from) )
				return true;

			return base.HandlesOnSpeech( from );
		}
		
		public override void OnSpeech( SpeechEventArgs e )
		{
			Mobile m = e.Mobile;
			PlayerMobile mobile = (PlayerMobile) m;
			
			string gesagt = e.Speech.ToLower();

			if ( m.InRange( this.Location, 5 ) && ( gesagt.IndexOf( "nechci" ) >= 0 || gesagt.IndexOf( "ne" ) >= 0 || gesagt.IndexOf( "odejdi" ) >= 0  ) )
			{
				this.Say( "Pokud neriskujes, nic neziskas." );
            this.CurrentSpeed = this.PassiveSpeed;
				m_NextPlapper = DateTime.Now + TimeSpan.FromSeconds( 120 );
			}
			
			if ( m.InRange( this.Location, 5 ) && ( gesagt.IndexOf( "chci" ) >= 0 || gesagt.IndexOf( "ano" ) >= 0 || gesagt.IndexOf( "jo" ) >= 0 ) )
			{
				this.Say( "Pokud neriskujes, nic neziskas." );
            this.CurrentSpeed = this.PassiveSpeed;
				m_NextPlapper = DateTime.Now + TimeSpan.FromSeconds( 120 );
				
				
				if ( ! mobile.HasGump( typeof( GambleGump ) ) )
				{
					mobile.SendGump( new GambleGump( mobile, this ));
				}
			}
			
			if ( gesagt.IndexOf( this.Name.ToLower() ) >= 0 )
			{
				this.Say( "Hm?" );
				m_NextPlapper = DateTime.Now + TimeSpan.FromSeconds( 120 );
			}
		}
		
		public override bool AlwaysMurderer{ get{ return false; } }

		public Gambler( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( m_hotovost );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			m_hotovost = reader.ReadInt();
			int version = reader.ReadInt();
		}
	}
}
//Gump

namespace Server.Gumps
{
	public class GambleGump : Server.Gumps.Gump
	{
		private Mobile m_mobile;
		private Gambler m_gambler;
		
		public GambleGump( Mobile mobile, Gambler gambler) : base(0, 0)
		{
			m_mobile = mobile;
			m_gambler = gambler;
			
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			this.AddPage(0);
			this.AddBackground(0, 0, 219, 261, 9200);
			this.AddRadio(14, 201, 209, 208, false, 11);
			this.AddRadio(48, 201, 209, 208, false, 12);
			this.AddRadio(80, 201, 209, 208, false, 13);
			this.AddRadio(114, 201, 209, 208, false, 14);
			this.AddRadio(146, 201, 209, 208, false, 15);
			this.AddRadio(180, 201, 209, 208, true, 16);
			this.AddImage(15, 177, 11280);
			this.AddImage(146, 177, 11284);
			this.AddImage(114, 177, 11283);
			this.AddImage(81, 177, 11282);
			this.AddImage(48, 177, 11281);
			this.AddImage(180, 177, 11285);
			this.AddLabel(15, 155, 1152, @"Vsadit na:");
			this.AddLabel(116, 227, 1152, @"Zl.");
			this.AddBackground(13, 226, 104, 24, 3000);
			this.AddTextEntry(15, 228, 98, 20, 0, 1, @"100");
			this.AddHtml( 10, 25, 198, 124, @"Vsad par svych zlataku na cislo 1 az 6.<br>Pokud toto cislo hodim jednou, ziskavas dvojnasobek vsazenych penez, pokud cislo padne dvakrat ziskavas ctyrnasobek vsazenych zlataku!<br>No a pokud toto cislo nehodim ani jednou... smula pro tebe.", (bool)true, (bool)true);
			this.AddLabel(63, 3, 32, @"Hra v kostky");
			this.AddButton(155, 226, 2450, 2451, 1, GumpButtonType.Reply, 0);
		}
		
		private int einsatz;
		private int tip;
		
		public override void OnResponse( NetState state, RelayInfo info ) //Function for GumpButtonType.Reply Buttons
		{
			Mobile from = state.Mobile;
			
			switch ( info.ButtonID )
			{
				case 0: //Case uses the ActionIDs defenied above. Case 0 defenies the actions for the button with the action id 0
					{
						break;
					}
				case 1: //Case uses the ActionIDs defenied above. Case 0 defenies the actions for the button with the action id 0
					{
						TextRelay text_einsatz = info.GetTextEntry(1);// the number one is what the textfield was assigned to in the enum

						if ( text_einsatz != null  && info.Switches.Length > 0 )
						{
							if (info.IsSwitched(11)) tip = 1;
							else if (info.IsSwitched(12)) tip = 2;
							else if (info.IsSwitched(13)) tip = 3;
							else if (info.IsSwitched(14)) tip = 4;
							else if (info.IsSwitched(15)) tip = 5;
							else tip = 6;

							try
							{
								einsatz = Convert.ToInt32( text_einsatz.Text );
								m_gambler.gamble(from, tip, einsatz);
							}
							catch
							{
								Console.WriteLine("gamble convert-crash abgefangen");
							}
						}
						break;
					}
				default:
					{
						break;
					}
			}
		}
	}
}
