using System;
using System.Collections;
using Server.Items;
using Server.Targeting;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a goblin corpse" )]
	public class GoblinAlchemist : BaseCreature
	{

		[Constructable]
		public GoblinAlchemist() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a goblin alchemist";
			Body = 17;
			BaseSoundID = 0x45A;
			Hue = 844;

			SetStr( 251, 300 );
			SetDex( 61, 80 );
			SetInt( 101, 150 );

			SetHits( 151, 210 );

			SetDamage( 6, 8 );

			SetHits( 486, 530 );
			SetMana( 17, 31 );

			SetDamage( 3, 10 );

			SetDamageType( ResistanceType.Physical, 75 );
			SetDamageType( ResistanceType.Fire, 25 );

			SetResistance( ResistanceType.Physical, 25, 35 );
			SetResistance( ResistanceType.Fire, 30, 40 );
			SetResistance( ResistanceType.Cold, 30, 40 );
			SetResistance( ResistanceType.Poison, 30, 40 );
			SetResistance( ResistanceType.Energy, 25, 30 );

			SetSkill( SkillName.MagicResist, 70.1, 85.0 );
			SetSkill( SkillName.Swords, 60.1, 85.0 );
			SetSkill( SkillName.Tactics, 75.1, 90.0 );
			SetSkill( SkillName.Wrestling, 60.1, 85.0 );

			Fame = 3500;
			Karma = -3500;

			VirtualArmor = 30;

			switch ( Utility.Random( 4 ) )
			{
				case 0: PackItem( new AgilityPotion() ); break;
				case 1: PackItem( new HealPotion() ); break;
				case 2: PackItem( new RefreshPotion() ); break;
				case 3: PackItem( new ClockParts() ); break;
			}

			PackItem( new Bottle( Utility.RandomMinMax( 2, 5 ) ) );
			PackItem( new SulfurousAsh( Utility.RandomMinMax( 6, 10 ) ) );
			PackItem( new MortarPestle() );
			PackItem( new LesserExplosionPotion() );

		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems,2);
		}

		public override bool CanRummageCorpses{ get{ return true; } }
        public override bool Unprovokable { get { return true; } }

		private DateTime m_NextBomb;
		private int m_Thrown;

		public override void OnActionCombat()
		{
			Mobile combatant = Combatant;

			if ( combatant == null || combatant.Deleted || combatant.Map != Map || !InRange( combatant, 12 ) || !CanBeHarmful( combatant ) || !InLOS( combatant ) )
				return;

			if ( DateTime.Now >= m_NextBomb )
			{
				ThrowBomb( combatant );

				m_Thrown++;

				if ( 0.75 >= Utility.RandomDouble() && (m_Thrown % 2) == 1 ) // 75% chance to quickly throw another bomb
					m_NextBomb = DateTime.Now + TimeSpan.FromSeconds( 3.0 );
				else
					m_NextBomb = DateTime.Now + TimeSpan.FromSeconds( 5.0 + (10.0 * Utility.RandomDouble()) ); // 5-15 seconds
			}
		}

		public void ThrowBomb( Mobile m )
		{
			DoHarmful( m );

			this.MovingParticles( m, 0xF0D, 1, 0, false, true, 0, 0, 9502, 6014, 0xF0D, EffectLayer.Waist, 0 );

			new InternalTimer( m, this ).Start();
		}

		private class InternalTimer : Timer
		{
			private Mobile m_Mobile, m_From;

			public InternalTimer( Mobile m, Mobile from ) : base( TimeSpan.FromSeconds( 1.0 ) )
			{
				m_Mobile = m;
				m_From = from;
				Priority = TimerPriority.OneSecond;
			}

			protected override void OnTick()
			{
				m_Mobile.PlaySound( 0x11D );
				AOS.Damage( m_Mobile, m_From, Utility.RandomMinMax( 10, 20 ), 0, 100, 0, 0, 0 );
			}
		}

		public GoblinAlchemist( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
