using System;
using System.Collections;
using Server.Items;
using Server.Targeting;
using Server.Misc;
using Server.Spells;

namespace Server.Mobiles
{
	//[CorpseName( "a goblin corpse" )] 
	public class GoblinPriest : BaseCreature
	{
		[Constructable]
		public GoblinPriest() : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a goblin priest";
			Body = 140;
			BaseSoundID = 0x45A;
			Hue = 971;

			SetStr( 251, 300 );
			SetDex( 61, 80 );
			SetInt( 101, 150 );

			SetHits( 181, 210 );

			SetDamage( 7, 13 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 35, 45 );
			SetResistance( ResistanceType.Fire, 35, 45 );
			SetResistance( ResistanceType.Cold, 30, 40 );
			SetResistance( ResistanceType.Poison, 10, 20 );
			SetResistance( ResistanceType.Energy, 35, 45 );

			SetSkill( SkillName.Anatomy, 80.1, 90.0 );
			SetSkill( SkillName.EvalInt, 100.2, 110.0 );
			SetSkill( SkillName.Magery, 100.1, 110.0 );
			SetSkill( SkillName.Meditation, 100.2, 110.0 );
			SetSkill( SkillName.MagicResist, 140.1, 150.0 );
			SetSkill( SkillName.Tactics, 80.1, 90.0 );
			SetSkill( SkillName.Wrestling, 80.1, 90.0 );

			Fame = 6000;
			Karma = -5000;

			VirtualArmor = 50;
			PackReg( 10, 15 );
			PackItem( new Bandage( Utility.RandomMinMax( 1, 15 ) ) );
			m_NextAbilityTime = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 2, 5 ) );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Average, 2 );
			AddLoot( LootPack.MedScrolls, 2 );
		}

		public override bool CanRummageCorpses{ get{ return true; } }
		public override int Meat{ get{ return 1; } }
        public override bool BardImmune { get { return true; } }
        public override bool Unprovokable { get { return true; } }
        public override bool Uncalmable { get { return true; } }

		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
			
			if ( 0.1 > Utility.RandomDouble() )
				GoblinHeal();
		}
      
		private DateTime m_NextAbilityTime;

		public void GoblinHeal()
		{
			if ( DateTime.Now >= m_NextAbilityTime )
			{
				ArrayList list = new ArrayList();

				foreach ( Mobile m in this.GetMobilesInRange( 8 ) )
					list.Add( m );

				if ( list.Count > 0 )
				{

					foreach ( Mobile m in list )
					{
						bool isFriendly = ( m is GoblinWarrior || m is GoblinTinker || m is GoblinAlchemist || m is GoblinMage );

						if ( !isFriendly )
							continue;


						if ( m.Poisoned || MortalStrike.IsWounded( m ) || !CanBeBeneficial( m ) )
							continue;

						if ( m.Hits < m.HitsMax )		
						   DoBeneficial( m );

						// Algorithm: (40% of magery) + (1-10)

						int toHeal = (int)(Skills[SkillName.Magery].Value * 0.4);
						toHeal += Utility.Random( 20, 50 );

						m.Heal( toHeal );

						m.FixedParticles( 0x376A, 9, 32, 5030, EffectLayer.Waist );
						m.PlaySound( 0x202 );

						m_NextAbilityTime = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 15, 20 ) );
					}
				}
			}
		}
		
        public override void AlterMeleeDamageTo( Mobile to, ref int damage )
        {
            damage = DecreaseDamage( to, damage );
            
            if ( to is Xanthos.Interfaces.IEvoCreature )
        		damage *= 10;
        }

		public GoblinPriest( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
