using System;
using System.Collections;
using Server.Items;
using Server.Targeting;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a goblin corpse" )]
	public class GoblinTinker : BaseCreature
	{

		private Mobile m_Golem;
		private bool m_SpawnedGolem;

		[Constructable]
		public GoblinTinker() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a goblin tinker";
			Body = 182;
			BaseSoundID = 0x45A;
			Hue = 864;

			SetStr( 151, 250 );
			SetDex( 61, 80 );
			SetInt( 101, 150 );

			SetHits( 151, 210 );

			SetDamage( 6, 10 );

			SetDamageType( ResistanceType.Physical, 75 );
			SetDamageType( ResistanceType.Fire, 25 );

			SetResistance( ResistanceType.Physical, 30, 40 );
			SetResistance( ResistanceType.Fire, 30, 40 );
			SetResistance( ResistanceType.Cold, 30, 40 );
			SetResistance( ResistanceType.Poison, 30, 40 );
			SetResistance( ResistanceType.Energy, 30, 40 );

			SetSkill( SkillName.MagicResist, 70.1, 85.0 );
			SetSkill( SkillName.Swords, 60.1, 85.0 );
			SetSkill( SkillName.Tactics, 75.1, 90.0 );
			SetSkill( SkillName.Wrestling, 60.1, 85.0 );

			Fame = 3500;
			Karma = -3500;

			VirtualArmor = 30;

			switch ( Utility.Random( 4 ) )
			{
				case 0: PackItem( new Gears() ); break;
				case 1: PackItem( new Hinge() ); break;
				case 2: PackItem( new Springs() ); break;
				case 3: PackItem( new ClockParts() ); break;
			}

			PackItem( new Hinge( Utility.RandomMinMax( 6, 8 ) ) );
			PackItem( new TinkerTools() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
			AddLoot( LootPack.Gems,2);
		}

		public override bool CanRummageCorpses{ get{ return true; } }
        public override bool Uncalmable { get { return true; } }

//////GOLEM//////
		public void CheckGolem()
		{
			if ( this.Hits <= 100 && !m_SpawnedGolem )
			{
				this.Say( "*Dokoncil vyrobu golema..." );

				m_Golem = new SumGolem();

				((BaseCreature)m_Golem).Team = this.Team;

				m_Golem.MoveToWorld( this.Location, this.Map );

				m_SpawnedGolem = true;
				PlaySound( 996 );
			}
			else if ( m_Golem != null && m_Golem.Deleted )
			{
				m_Golem = null;
			}
		}

		public override void OnGotMeleeAttack( Mobile attacker )
		{
			base.OnGotMeleeAttack( attacker );
			CheckGolem();
		}

//////GOLEM//////

		public GoblinTinker( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
