using System;
using System.Collections;
using Server.Items;
using Server.Targeting;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName("a gelatinous corpse")]
	public class Jelly : BaseCreature
	{
		private DateTime m_Delay = DateTime.Now;

		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.ParalyzingBlow : WeaponAbility.CrushingBlow;
		}

		[Constructable]
		public Jelly()
		: base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			//yellow, green, pink, orange, white, red, blue
            int jellyhue = Utility.RandomList(1934, 1080, 1071, 1971, 1976, 1178, 1266);

			switch (jellyhue)
			{
				case 1934: Name = "an yellow jelly"; break;
				case 1080: Name = "a green jelly"; break;
				case 1071: Name = "a pink jelly"; break;
				case 1971: Name = "an orange jelly"; break;
				case 1976: Name = "a white jelly"; break;
				case 1178: Name = "a red jelly"; break;
				case 1266: Name = "a blue jelly"; break;
			}

			Hue = jellyhue;
			Body = 51;
			BaseSoundID = 456;

			SetStr(620, 740);
			SetDex(66, 71);
			SetInt(16, 20);

			SetHits(1000, 1500);

			SetDamage(10, 15);

			SetDamageType(ResistanceType.Physical, 20);
			SetDamageType(ResistanceType.Poison, 80);

			SetResistance(ResistanceType.Physical, 50, 70);
			SetResistance(ResistanceType.Fire, 40, 60);
			SetResistance(ResistanceType.Cold, 50, 70);
			SetResistance(ResistanceType.Poison, 100);
			SetResistance(ResistanceType.Energy, 40, 60);

			SetSkill(SkillName.Poisoning, 100.1, 120.0);
			SetSkill(SkillName.MagicResist, 95.1, 120.0);
			SetSkill(SkillName.Tactics, 99.3, 104.0);
			SetSkill(SkillName.Wrestling, 99.3, 114.0);
			SetSkill(SkillName.Anatomy, 90.1, 100.0);

			Fame = 22500;
			Karma = -800;

			VirtualArmor = 50;

			AddItem(new LightSource());
			Tamable = false;

			if (0.1 > Utility.RandomDouble())
			{
				switch (Utility.Random(5))
				{
					default:
                    case 0: PackItem(new BardBones()); break;
					case 1: PackItem(new RogueBones()); break;
					case 2: PackItem(new MageBones()); break;
					case 3: PackItem(new WarriorBones()); break;
					case 4: PackItem(new HealerBones()); break;
				}
			}

			PackItem(Loot.RandomNewPotion());
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.UltraRich);
			AddLoot(LootPack.FilthyRich);
			AddLoot(LootPack.Gems, 20);
		}

		public override void AlterMeleeDamageFrom(Mobile from, ref int damage)
		{
			if (from == null)
				return;

			Item item = from.FindItemOnLayer(Layer.OneHanded);

			if (item == null)
				item = from.FindItemOnLayer(Layer.TwoHanded);

			if (item is BaseWeapon)
			{
				BaseWeapon whatWeapon = (BaseWeapon)item;
				if (whatWeapon.Type == WeaponType.Bashing || whatWeapon.Type == WeaponType.Fists || whatWeapon.Type == WeaponType.Staff)
				{
					from.Stam -= Utility.Random(6, 20);
					DamageWeapon(from, whatWeapon);
				}
				else if (whatWeapon.Type == WeaponType.Axe || whatWeapon.Type == WeaponType.Slashing || whatWeapon.Type == WeaponType.Polearm)
				{
					if (Utility.RandomDouble() < 0.5)
					{
						Mobile summon = null;
						summon = new SumSlime();
						summon.MoveToWorld(Location, Map);
					}

					damage = Utility.RandomList(1, 10);
					DamageWeapon(from, whatWeapon);
				}
				else if (whatWeapon.Type == WeaponType.Piercing || whatWeapon.Type == WeaponType.Ranged)
				{
					from.SendMessage("Sliz je imunni na tento typ utoku.");
					damage = 0;
				}
			}
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			if (DateTime.Now > m_Delay)
			{
				Ability.Aura(this, 60, 120, 3, 6, 4, "Castecky odletujiciho slizu te zasahly do tvare.", true);
				m_Delay = DateTime.Now + TimeSpan.FromSeconds(Utility.RandomMinMax(10, 30));
			}

			base.OnDamage(amount, from, willKill, typ);
		}

		public override bool OnBeforeDeath()
		{
			SpillAcid(TimeSpan.FromSeconds(10), 10, 30, 4, 6);
			return base.OnBeforeDeath();
		}

		public virtual void DamageWeapon(Mobile from, BaseWeapon weapon)
		{
			if (weapon.HitPoints > 2 && weapon.Resource == CraftResource.Iron && Utility.RandomDouble() < 0.3)
			{
				weapon.HitPoints -= 1;
				from.LocalOverheadMessage(MessageType.Regular, 0x3B2, 500263); // *Acid blood scars your weapon!*
			}
		}

		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		// 		public override Poison HitPoison{ get{ return Poison.Regular; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override bool BleedImmune { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

        public Jelly(Serial serial)
		: base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int)0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}