using System;
using System.Collections;
using Server.Items;
using Server.ContextMenus;
using Server.Misc;
using Server.Network;
using System.Collections.Generic;

namespace Server.Mobiles
{
	//[CorpseName( "a mad crafter corpse" )]
	public class MadCrafter : BaseCreature
	{
		public override int GetIdleSound()
		{
			return 573; //play carpentry sound
		}
		
		public override int GetAttackSound()
		{
			return 42; // play blacksmith sound
		}

		private DateTime m_NextSpeechTime = DateTime.Now;
		
		string[] MadCrafterSay = new string[]
		{
			"Muj nejoblibenejsi vyrobek jsou rakve, budes prvni zakaznik!",
			"Miluju cervenou barvu, miluju barvu krve!",
			"Mohu si vzit miry na tvuj pohrebni rubas?",
			"Potrebuji si na nekom otestovat zbran kterou jsem prave vyrobil!"
		};
		
		[Constructable]
		public MadCrafter() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Title = "the Mad Crafter";

			SpeechHue = Utility.RandomDyedHue();

			Hue = Utility.RandomSkinHue();
			Body = 0x190;
			Name = NameList.RandomName( "male" );
			new Beetle().Rider = this;
			AddItem( new PlateGloves() );
			AddItem( new Shirt(Utility.RandomNeutralHue()) );
			AddItem( new PlateLegs() );
			AddItem( new WarHammer() );
			AddItem( new FullApron() );
			
			SetStr( 206, 300 );
			SetDex( 50, 75 );
			SetInt( 61, 75 );

			SetDamage( 5, 45 );
			SetHits( 3051, 4475 );
			
			SetResistance( ResistanceType.Physical, 60, 70 );
			SetResistance( ResistanceType.Fire, 50, 60 );
			SetResistance( ResistanceType.Cold, 50, 60 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 50, 60 );

			SetSkill( SkillName.Fencing, 76.0, 90.5 );
			SetSkill( SkillName.Macing, 95.0, 110.5 );
			SetSkill( SkillName.MagicResist, 45.0, 77.5 );
			SetSkill( SkillName.Swords, 75.0, 90.5 );
			SetSkill( SkillName.Tactics, 75.0, 100.5 );
			SetSkill( SkillName.Wrestling, 35.0, 87.5 );
			SetSkill( SkillName.Anatomy, 50.1, 90.0 );
			
			PackGold( 1950, 2500 );

			Fame = 9000;
			Karma = -9000;
			VirtualArmor = 56;
			HairItemID = 0x203B;	//ShortHair
			HairHue = 1105;
			FacialHairItemID = 0x2041; // Mustache
			FacialHairHue = 1105;
			
 			if( 0.2 > Utility.RandomDouble() )
 			   PackItem( ClothingSkillScroll.CreateRandomCraft( 1, Utility.RandomList( 1, 1, 1, 1, 1, 1, 2, 2, 3 ) ) );
			
			//runic tool
			if (Utility.RandomDouble() < 0.1)
				PackItem( Loot.RandomRunicTool() );
				
			if (Utility.RandomDouble() < 0.3)
				PackItem( new RandomTalisman() );

			//recipes
			if (Utility.RandomDouble() < 0.05)
				PackItem( new RecipeScrollTinkerNeonRing() );

			if (Utility.RandomDouble() < 0.05)
				PackItem( new RecipeScrollCarpMagicFountain() );
				
			if (Utility.RandomDouble() < 0.05)
				PackItem( new RecipeJewelryPolishingSolution() );
			
			PackItem( Loot.RandomNewPotion() );
			
			//craft powerscroll
			if (Utility.RandomDouble() < 0.7)
			{
				int slevel;
				double random = Utility.RandomDouble();
				
				if ( 0.1 >= random )
					slevel = 20;
				else if ( 0.4 >= random )
					slevel = 15;
				else if ( 0.7 >= random )
					slevel = 10;
				else
					slevel = 5;
				
				PowerScroll ps = PowerScroll.CreateRandomCraft(slevel,slevel);
				PackItem( ps );
			}
			
			Item res = Loot.RandomResource();
			res.Amount = Utility.RandomMinMax( 50, 150 );
			PackItem( res );
		}
		
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.ArmorIgnore;
		}
		
		public override bool AlwaysMurderer{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 4; } }

		public MadCrafter( Serial serial ) : base( serial )
		{
		}
		
		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;
			if   ( mount != null )
				mount.Rider = null;
			
			if ( mount is Mobile )
			{
				((Mobile)mount).Delete();
			}
			return base.OnBeforeDeath();
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );

			Mobile m = FindMostRecentDamager( false );
			
			if ( m != null && m.Player )
			{
				bool gainedPath = false;
				
				if ( VirtueHelper.Award( m, VirtueName.Justice, 250, ref gainedPath ) )
				{
					if ( gainedPath )
						m.SendLocalizedMessage( 1049367 ); // You have gained a path in Justice!
					else
						m.SendLocalizedMessage( 1049363 ); // You have gained in Justice.
					
					m.FixedParticles( 0x375A, 9, 20, 5027, EffectLayer.Waist );
					m.PlaySound( 0x1F7 );
				}
			}
		}
		
		public override void OnMovement( Mobile m, Point3D oldLocation )
		{
			if ( DateTime.Now > m_NextSpeechTime && m.InRange( this, 3 ) && m is PlayerMobile && !m.Hidden )
			{
				m_NextSpeechTime = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 10, 20 ) );
				SayRandom( MadCrafterSay, this );
				PlaySound( Utility.RandomList( 1066, 1071, 1055, 1074, 1067, 1073, 1094 ) );
				this.Move( GetDirectionTo( m.Location ) );
			}
		}

		private static void SayRandom( string[] say, Mobile m )
		{
			m.Say( say[Utility.Random( say.Length )] );
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
