using System;
using Server;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Targeting;

namespace Server.Mobiles
{
	public class MadSquirrel : BaseCreature
	{
		private Mobile m_Target;
		private DateTime m_ExpireTime = DateTime.MinValue;

		public override Mobile ConstantFocus{ get{ return m_Target; } }
		public override bool NoHouseRestrictions{ get{ return true; } }
		public override bool DeleteCorpseOnDeath{ get{ return true; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override bool BardImmune{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp

		[Constructable]
		public MadSquirrel() : this ( null, 3.0 )
		{
		}
		
		[Constructable]
		public MadSquirrel( double duration ) : this ( null, duration )
		{
		}
		
		[Constructable]
		public MadSquirrel( Mobile target, double duration ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.16, 0.3 )
		{
			Name = "a mad squirrel";
			Body = 0x116;
			BaseSoundID = 0xCC;
			
			m_Target = target;
			
			if ( duration > 0 )
				m_ExpireTime = DateTime.Now + TimeSpan.FromMinutes( duration );

			SetStr( 20, 50 );
			SetDex( 155 );
			SetInt( 5 );

			SetHits( 12, 20 );

			SetDamage( 1, 2 );

			SetDamageType( ResistanceType.Fire, 100 );

			SetResistance( ResistanceType.Physical, 30, 34 );
			SetResistance( ResistanceType.Fire, 10, 14 );
			SetResistance( ResistanceType.Cold, 30, 35 );
			SetResistance( ResistanceType.Poison, 20, 25 );
			SetResistance( ResistanceType.Energy, 20, 25 );

			SetSkill( SkillName.MagicResist, 100.0 );
			SetSkill( SkillName.Tactics, 150.0 );
			SetSkill( SkillName.Wrestling, 150.0 );
			SetSkill( SkillName.DetectHidden, 100.0 );

			Fame = 0;
			Karma = 0;
			Tamable = false;
			VirtualArmor = 32;
		}

		public override void OnThink()
		{
			if ( m_ExpireTime != DateTime.MinValue && DateTime.Now > m_ExpireTime )
			{
				Kill();
				return;
			}
			
         if ( m_Target == null && Combatant == null )
			{
				base.OnThink();
				return;
			}
			else if ( m_Target == null && Combatant != null )
			{
				if ( Combatant is BaseCreature )
				{
					BaseCreature bc = (BaseCreature)Combatant;

					if ( bc.Controlled && bc.ControlMaster != null )
						m_Target = bc.ControlMaster;
					else if ( bc.Summoned && bc.SummonMaster != null )
						m_Target = bc.SummonMaster;
					else
						m_Target = Combatant;
				}
				else
					m_Target = Combatant;
				
				base.OnThink();
				return;
			}
			
			if ( !m_Target.Alive || Map != m_Target.Map || !InRange( m_Target, 25 ) )
			{
				Kill();
				return;
			}

			if ( m_Target.Hidden && InRange( m_Target, 3 ) && DateTime.Now >= this.NextSkillTime && UseSkill( SkillName.DetectHidden ) )
			{
				Target targ = this.Target;

				if ( targ != null )
					targ.Invoke( this, this );
			}

			Combatant = m_Target;
			FocusMob = m_Target;

			if ( AIObject != null )
				AIObject.Action = ActionType.Combat;

			base.OnThink();
		}
		
		public override bool OnBeforeDeath()
		{
			Effects.PlaySound( Location, Map, 0x307 );
			Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 14000, 9, 32, 5024 );

// 			SulfurousAsh sa = new SulfurousAsh( Utility.RandomMinMax( 5, 10 ) );
// 			sa.MoveToWorld( Location, Map );
			
			Aura();
			Effects.PlaySound( Location, Map, 203 );
			Delete();
			
			return false;
		}
		
		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			Kill();
		}
		
		public override void OnGaveMeleeAttack( Mobile defender )
		{
			Kill();
		}
		
		private void Aura()
		{
			ArrayList targets = Utilitky.GetTargets( this, 6, true );

			for (int i = 0; i < targets.Count; ++i)
			{
				Mobile m = (Mobile)targets[i];
				
				if ( m == null || m.Deleted )
					continue;

				m.RevealingAction();
				this.DoHarmful(m);

				int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage( Utility.Random( 20, 25 ), m );//( Utility.RandomBool() ) ?  Engines.XmlSpawner2.XmlSpecial.PercentualDamage( Utility.Random( 20, 25 ), m ) : Utility.Random( 60, 100 );
				int scalebyrange;

				if (m.InRange(this.Location, 2))
					scalebyrange = 1;
				else
					scalebyrange = 2;

				auradamage /= scalebyrange;

				Effects.SendLocationParticles( EffectItem.Create( m.Location, Map, EffectItem.DefaultDuration ), 0x36BD, 20, 10, 5044 );
				Effects.PlaySound( m.Location, Map, 520 );
				//Ability.DamageArmor( m, 3, 6 );
				
				m.Hits -= auradamage;
				ISTile5.SendDmgPacket( m, auradamage );
				if (m.Hits < 2)
					m.Kill();
			}
		}
		
		public override int GetAttackSound() 
		{ 
			return 0xC9; 
		} 

		public MadSquirrel( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			Delete();
		}
	}
}
