using System;
using Server;
using Server.Items;
using System.Collections;
using Server.Network;

namespace Server.Mobiles
{
    //[CorpseName("a medusa corpse")]
    public class Medusa : BaseCreature
    {
        private bool m_Stunning;

        public override WeaponAbility GetWeaponAbility()
        {
            return WeaponAbility.WhirlwindAttack;
        }

        [Constructable]
        public Medusa()
            : base(AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4)
        {
            Name = "a medusa";
            SpeechHue = 1157;
            Body = 87;
            Hue = 1368;

            SetStr(496, 625);
            SetDex(101, 110);
            SetInt(601, 740);

            SetHits(2500);

            SetDamage(10, 15);

            SetDamageType(ResistanceType.Physical, 25);
            SetDamageType(ResistanceType.Poison, 75);

            SetResistance(ResistanceType.Physical, 60);
            SetResistance(ResistanceType.Fire, 50);
            SetResistance(ResistanceType.Cold, 50);
            SetResistance(ResistanceType.Poison, 90);
            SetResistance(ResistanceType.Energy, 50);

            SetSkill(SkillName.SpiritSpeak, 118.1, 120.0);
            SetSkill(SkillName.Necromancy, 112.6, 120.0);
            SetSkill(SkillName.Meditation, 150.0);
            SetSkill(SkillName.Poisoning, 120.0);
            SetSkill(SkillName.MagicResist, 90.1, 90.9);
            SetSkill(SkillName.Tactics, 100.0);
            SetSkill(SkillName.Wrestling, 90.1, 90.9);

            Fame = 13200;
            Karma = -6200;

            VirtualArmor = 54;

            PackItem(new Tokens(Utility.RandomMinMax(5, 10)));
            PackItem( Loot.RandomNewPotion() );
        }

        public override void GenerateLoot()
        {
            AddLoot(LootPack.UltraRich);
            AddLoot(LootPack.FilthyRich, 3);
        }

        public void StoneGaze(Mobile m)
        {
            if ( !m_Stunning && 0.1 > Utility.RandomDouble() && !( m.Talisman is WisdomOfAncientForest ) )
            {
                m_Stunning = true;

                if (m.Alive)
                {
                    m.Animate(21, 6, 1, true, false, 0);
                    this.PlaySound(541);
                    m.LocalOverheadMessage(MessageType.Regular, 0x3B2, false, "Pohled meduzy te promenil v kamen!");
                    m.FixedEffect(0x376A, 6, 1);
                    m.Frozen = true;
                    Timer.DelayCall(TimeSpan.FromSeconds(5.0), new TimerStateCallback(Recover_Callback), m);
                }
            }
        }

        private void Recover_Callback(object state)
        {
            Mobile defender = state as Mobile;

            if (defender != null)
            {
                defender.Frozen = false;
                defender.PlaySound(65);
                defender.Combatant = null;
                defender.LocalOverheadMessage(MessageType.Regular, 0x3B2, false, "Opet se muzes hybat.");
            }

            m_Stunning = false;
        }

        public void SpawnSnakes(Mobile target)
        {
            Map map = this.Map;

            if (map == null)
                return;

            int newSnakes = 4;

            for (int i = 0; i < newSnakes; ++i)
            {
                MeerGiantSerpent snake = new MeerGiantSerpent();

                snake.Team = this.Team;
                snake.FightMode = FightMode.Closest;
                snake.Name = "Snake";
                snake.Body = 52;
                snake.Hue = Utility.RandomSnakeHue();
                snake.BaseSoundID = 0xDB;

                bool validLocation = false;
                Point3D loc = this.Location;

                for (int j = 0; !validLocation && j < 10; ++j)
                {
                    int x = X + Utility.Random(3) - 1;
                    int y = Y + Utility.Random(3) - 1;
                    int z = map.GetAverageZ(x, y);

                    if (validLocation = map.CanFit(x, y, this.Z, 16, false, false))
                        loc = new Point3D(x, y, Z);
                    else if (validLocation = map.CanFit(x, y, z, 16, false, false))
                        loc = new Point3D(x, y, z);
                }

                snake.MoveToWorld(loc, map);
                snake.Combatant = target;

                target.PlaySound(219);
            }
        }

        public override void OnGotMeleeAttack(Mobile attacker)
        {
            base.OnGotMeleeAttack(attacker);

            StoneGaze(attacker);

            if (0.1 >= Utility.RandomDouble())
                SpawnSnakes(attacker);
        }

        public override void OnDamagedBySpell(Mobile attacker)
        {
            base.OnDamagedBySpell(attacker);
            StoneGaze(attacker);
        }

        public override void AlterMeleeDamageTo( Mobile to, ref int damage )
        {
            damage = DecreaseDamage( to, damage );
            
            if ( to is Xanthos.Interfaces.IEvoCreature )
        		  damage *= 5;
        }

        public override int GetIdleSound()
        {
            return 888;
        }

        public override int GetAngerSound()
        {
            return 884;
        }

        public override int GetHurtSound()
        {
            return 885;  ////887 883
        }

        public override int GetDeathSound()
        {
            return 886;
        }

		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
        public override Poison PoisonImmune { get { return Poison.Lethal; } }
        public override Poison HitPoison { get { return (0.8 >= Utility.RandomDouble() ? Poison.Greater : Poison.Deadly); } }
        public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp
        public override bool IsScaredOfScaryThings { get { return false; } }
        public override bool IsScaryToPets { get { return true; } }
        public override int Meat { get { return 5; } }
        public override int Hides { get { return 10; } }
        public override HideType HideType { get { return HideType.Barbed; } }

        public Medusa(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }
    }
}